/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleViewExpressionDialog;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleViewExpressionEditor;

public class ScheduleViewEditor
extends AbstractIMObjectEditor {
    private final PropertyEditor expressionEditor;

    public ScheduleViewEditor(Entity object, IMObject parent, LayoutContext layoutContext) {
        super((IMObject)object, parent, layoutContext);
        this.expressionEditor = new ExpressionEditor(this.getProperty("displayExpression"), (IMObject)object, this.getLayoutContext());
        this.addEditor((Editor)this.expressionEditor);
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new AbstractLayoutStrategy(){

            protected ComponentState createComponent(Property property, IMObject parent, LayoutContext context) {
                if ("displayExpression".equals(property.getName())) {
                    return new ComponentState(ScheduleViewEditor.this.expressionEditor.getComponent(), ScheduleViewEditor.this.expressionEditor.getProperty(), ScheduleViewEditor.this.expressionEditor.getFocusGroup());
                }
                return super.createComponent(property, parent, context);
            }

            protected int getColumns(List<Property> properties) {
                return 1;
            }
        };
    }

    private static class ExpressionEditor
    extends AbstractPropertyEditor {
        private final Component container;
        private final FocusGroup focus;
        private final ScheduleViewExpressionEditor editor;
        private final HelpContext help;

        public ExpressionEditor(Property property, IMObject parent, LayoutContext context) {
            super(property);
            ComponentState state = context.getComponentFactory().create(property, parent);
            Component field = state.getComponent();
            Button test = ButtonFactory.create((String)"test", this::onTest);
            this.focus = state.getFocusGroup();
            this.focus.add((Component)test);
            this.container = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{field, test});
            boolean scheduleView = TypeHelper.isA((IMObject)parent, (String)"entity.organisationScheduleView");
            this.editor = new ScheduleViewExpressionEditor(property, scheduleView);
            this.help = context.getHelpContext();
        }

        public Component getComponent() {
            return this.container;
        }

        public FocusGroup getFocusGroup() {
            return this.focus;
        }

        protected boolean doValidation(Validator validator) {
            boolean valid = super.doValidation(validator);
            if (valid) {
                try {
                    this.editor.evaluate();
                }
                catch (Throwable exception) {
                    valid = false;
                    ValidatorError error = new ValidatorError(this.getProperty(), exception.getMessage());
                    validator.add((Modifiable)this.getProperty(), error);
                }
            }
            return valid;
        }

        private void onTest() {
            String title = Messages.format((String)"editor.edit.title", (Object[])new Object[]{this.editor.getDisplayName()});
            ScheduleViewExpressionDialog dialog = new ScheduleViewExpressionDialog(title, this.editor, this.help.subtopic("test"));
            dialog.show();
        }
    }
}

