/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import echopointng.PopUp;
import echopointng.layout.TableLayoutDataEx;
import echopointng.table.TableCellRendererEx;
import java.util.Objects;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.layout.TableLayoutData;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.echo.colour.ColourHelper;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.PopUpFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;

public abstract class ScheduleTableCellRenderer
implements TableCellRendererEx {
    public static final String EVEN_ROW_STYLE = "ScheduleTable.Even";
    public static final String ODD_ROW_STYLE = "ScheduleTable.Odd";
    private final ScheduleTableModel model;
    private final ScheduleColours colours;
    private int previousRow = -1;
    private boolean newPrompt = false;

    public ScheduleTableCellRenderer(ScheduleTableModel model) {
        this.model = model;
        this.colours = model.getColours();
    }

    public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
        Component component = value instanceof PropertySet ? this.getEvent(table, (PropertySet)value, column, row) : this.getComponent(table, value, column, row);
        if (component != null) {
            if (this.isCut(column, row)) {
                this.cutCell(table, component);
            } else if (this.canHighlightCell(column, row, value)) {
                this.highlightCell(component);
            }
        }
        return component;
    }

    public boolean isSelectionCausingCell(Table table, int column, int row) {
        return this.model.getAvailability(column, row) != ScheduleEventGrid.Availability.UNAVAILABLE;
    }

    public boolean isActionCausingCell(Table table, int column, int row) {
        return this.model.getAvailability(column, row) != ScheduleEventGrid.Availability.UNAVAILABLE;
    }

    protected ScheduleTableModel getModel() {
        return this.model;
    }

    protected Component getEvent(Table table, PropertySet event, int column, int row) {
        return new Label();
    }

    protected Component getComponent(Table table, Object value, int column, int row) {
        if (this.previousRow != row) {
            this.newPrompt = false;
        }
        Component component = null;
        if (value instanceof Component) {
            component = (Component)value;
        } else {
            ScheduleEventGrid.Availability availability = this.model.getAvailability(column, row);
            if (availability != ScheduleEventGrid.Availability.UNAVAILABLE) {
                if (value == null && availability == ScheduleEventGrid.Availability.FREE) {
                    Cell cell = this.model.getSelected();
                    if (cell != null && row == cell.getRow() && !this.newPrompt && this.renderNewPrompt(this.model, column, row)) {
                        component = LabelFactory.create((String)"workflow.scheduling.table.new");
                        this.highlightCell(component);
                        this.newPrompt = true;
                    }
                } else {
                    Label label = LabelFactory.create();
                    if (value != null) {
                        label.setText(value.toString());
                    }
                    component = label;
                }
            }
        }
        if (component != null) {
            PropertySet event = this.model.getEvent(column, row);
            if (event != null) {
                this.styleEvent(event, component, table);
            } else {
                this.colourCell(component, column, row, this.model);
            }
        }
        this.previousRow = row;
        return component;
    }

    protected void styleEvent(PropertySet event, Component component, Table table) {
        String status;
        TableLayoutDataEx layout = this.getEventLayoutData(event, this.model);
        if (layout != null) {
            Color background = layout.getBackground();
            if (background != null) {
                this.setForegroundFromBackground(component, background);
            }
            TableHelper.mergeStyle((Component)component, (TableLayoutData)layout, (boolean)true);
        }
        if (this.model.useStrikeThrough() && ("COMPLETED".equals(status = event.getString("act.status")) || "CANCELLED".equals(status))) {
            this.setStrikethroughFont(component, table);
        }
    }

    protected String evaluate(PropertySet event) {
        return this.model.evaluate(event);
    }

    protected Component createLabelWithNotes(String text, String notes) {
        Label result;
        Label label = LabelFactory.text((String)text, (boolean)false);
        notes = StringUtils.trimToNull((String)notes);
        if (this.model.getDisplayNotes() && notes != null) {
            org.openvpms.web.echo.popup.PopUp popUp = PopUpFactory.createPopUpNotes((String)notes);
            result = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{label, popUp});
        } else {
            result = label;
        }
        return result;
    }

    protected boolean canHighlightCell(int column, int row, Object value) {
        boolean highlight = false;
        boolean single = this.model.isSingleScheduleView();
        Cell cell = this.model.getSelected();
        if (single && cell != null && cell.getRow() == row || !single && this.model.isSelected(column, row) && this.model.getAvailability(column, row) == ScheduleEventGrid.Availability.BUSY) {
            highlight = true;
        }
        return highlight;
    }

    protected boolean isCut(int column, int row) {
        return this.model.isCut() && this.model.isMarked(column, row);
    }

    protected void highlightCell(Component component) {
        TableHelper.mergeStyle((Component)component, (String)"ScheduleTable.Selected", (boolean)true);
        Color colour = component.getForeground();
        if (colour != null && component.getComponentCount() != 0) {
            this.setForeground(component, colour);
        }
    }

    protected void cutCell(Table table, Component component) {
        this.setStrikethroughFont(component, table);
    }

    protected String getFreeStyle(ScheduleTableModel model, int row) {
        return row % 2 == 0 ? EVEN_ROW_STYLE : ODD_ROW_STYLE;
    }

    protected void colourCell(Component component, int column, int row, ScheduleTableModel model) {
        ScheduleEventGrid.Availability avail = model.getAvailability(column, row);
        this.colourCell(component, avail, model, row);
    }

    protected void colourCell(Component component, ScheduleEventGrid.Availability avail, ScheduleTableModel model, int row) {
        String style = this.getStyle(avail, model, row);
        TableHelper.mergeStyle((Component)component, (String)style);
    }

    protected String getStyle(ScheduleEventGrid.Availability avail, ScheduleTableModel model, int row) {
        String style;
        switch (avail) {
            case BUSY: {
                style = "ScheduleTable.Busy";
                break;
            }
            case FREE: {
                style = this.getFreeStyle(model, row);
                break;
            }
            default: {
                style = "ScheduleTable.Unavailable";
            }
        }
        return style;
    }

    protected TableLayoutDataEx getEventLayoutData(PropertySet event, ScheduleTableModel model) {
        TableLayoutDataEx result;
        if (!this.isSelectedClinician(event, model)) {
            result = TableHelper.getTableLayoutDataEx((String)"ScheduleTable.Busy");
        } else {
            ScheduleTableModel.Highlight highlight = model.getHighlight();
            result = this.getEventLayoutData(event, highlight);
        }
        return result;
    }

    protected TableLayoutDataEx getEventLayoutData(PropertySet event, ScheduleTableModel.Highlight highlight) {
        TableLayoutDataEx result = null;
        if (highlight == ScheduleTableModel.Highlight.STATUS) {
            String style = this.getStatusStyle(event);
            result = TableHelper.getTableLayoutDataEx((String)style);
        } else {
            Color colour = this.getEventColour(event, highlight);
            if (colour != null) {
                result = new TableLayoutDataEx();
                result.setBackground(colour);
            }
        }
        return result;
    }

    protected Font getFont(Component component) {
        Font font = component.getFont();
        if (font == null && (font = (Font)component.getRenderProperty("font")) == null && component.getParent() != null) {
            font = this.getFont(component.getParent());
        }
        return font;
    }

    protected Color getColour(Reference reference) {
        return this.colours.getColour(reference);
    }

    private String getStatusStyle(PropertySet event) {
        return "ScheduleTable." + event.getString("act.status");
    }

    private boolean isSelectedClinician(PropertySet event, ScheduleTableModel model) {
        Reference clinician = model.getClinician();
        return clinician == null || Objects.equals(clinician, event.getReference("clinician.objectReference"));
    }

    private boolean renderNewPrompt(ScheduleTableModel model, int column, int row) {
        boolean result = false;
        Cell cell = model.getSelected();
        if (cell != null) {
            int selected = cell.getColumn();
            if (selected == column) {
                result = true;
            } else if (model.isSingleScheduleView() && (column == selected - 1 || column == selected + 1) && model.getValueAt(selected, row) != null) {
                result = true;
            }
        }
        return result;
    }

    private Color getEventColour(PropertySet event, ScheduleTableModel.Highlight highlight) {
        Color result = null;
        if (event != null) {
            switch (highlight) {
                case EVENT_TYPE: {
                    result = this.getColour(event, "scheduleType.objectReference");
                    break;
                }
                case CLINICIAN: {
                    result = this.getColour(event, "clinician.objectReference");
                }
            }
        }
        return result;
    }

    private Color getColour(PropertySet set, String key) {
        IMObjectReference reference = set.getReference(key);
        return this.getColour((Reference)reference);
    }

    private void setStrikethroughFont(Component component, Table table) {
        Font font = this.getFont((Component)table);
        if (font != null) {
            int style = 17;
            font = new Font(font.getTypeface(), style, font.getSize());
            this.setFont(component, font);
        }
    }

    private void setFont(Component component, Font font) {
        for (Component child : component.getComponents()) {
            this.setFont(child, font);
        }
        component.setFont(font);
    }

    private void setForegroundFromBackground(Component component, Color background) {
        this.setForeground(component, ColourHelper.getTextColour((Color)background));
    }

    private void setForeground(Component component, Color colour) {
        if (component instanceof Row) {
            for (Component child : component.getComponents()) {
                this.setForeground(child, colour);
            }
        } else if (!(component instanceof PopUp)) {
            component.setForeground(colour);
        }
    }
}

