/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.ScheduleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.im.clinician.ClinicianSelectField;
import org.openvpms.web.component.im.list.LookupListCellRenderer;
import org.openvpms.web.component.im.list.LookupListModel;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.query.DateNavigator;
import org.openvpms.web.component.im.query.DateSelector;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleQuery;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;
import org.openvpms.web.workspace.workflow.scheduling.Schedules;

public abstract class ScheduleServiceQuery
extends ScheduleQuery {
    private final ScheduleService service;
    private final Preferences prefs;
    private DateSelector date;
    private SelectField highlightSelector;
    private SelectField clinicianSelector;

    public ScheduleServiceQuery(ScheduleService service, Schedules schedules, Preferences prefs) {
        super(schedules);
        this.service = service;
        this.prefs = prefs;
    }

    public Date getDate() {
        return this.date.getDate();
    }

    public void setDate(Date date) {
        this.date.setDate(date);
    }

    public Map<Entity, ScheduleEvents> query() {
        this.getComponent();
        return this.getEvents();
    }

    public boolean updated(Map<Entity, ScheduleEvents> events) {
        Date date = this.getDate();
        for (Map.Entry<Entity, ScheduleEvents> entry : events.entrySet()) {
            if (!this.updated(entry.getKey(), entry.getValue(), date)) continue;
            return true;
        }
        return false;
    }

    public User getClinician() {
        return (User)this.clinicianSelector.getSelectedItem();
    }

    public ScheduleTableModel.Highlight getHighlight() {
        ScheduleTableModel.Highlight result = null;
        Object selected = this.highlightSelector.getSelectedItem();
        if (selected != null) {
            result = ScheduleTableModel.Highlight.valueOf(selected.toString());
        }
        if (result == null) {
            result = ScheduleTableModel.Highlight.EVENT_TYPE;
        }
        return result;
    }

    public void setDateNavigator(DateNavigator navigator) {
        this.date.setNavigator(navigator);
    }

    protected boolean updated(Entity schedule, ScheduleEvents events, Date date) {
        long hash = this.service.getModHash(schedule, date);
        return hash == -1L || hash != events.getModHash();
    }

    protected abstract Reference getDefaultClinician();

    protected abstract ScheduleTableModel.Highlight getDefaultHighlight();

    protected ScheduleEvents getEvents(Entity schedule, Date date) {
        return this.service.getScheduleEvents(schedule, date);
    }

    protected Preferences getPreferences() {
        return this.prefs;
    }

    protected SelectField createHighlightSelector() {
        NodeLookupQuery lookups = new NodeLookupQuery(this.getSchedules().getScheduleViewShortName(), "highlight");
        LookupListModel model = new LookupListModel((LookupQuery)lookups);
        SelectField result = SelectFieldFactory.create((ListModel)model);
        result.setCellRenderer((ListCellRenderer)LookupListCellRenderer.INSTANCE);
        result.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ScheduleServiceQuery.this.onQuery();
            }
        });
        return result;
    }

    @Override
    protected void doLayout(Component container) {
        super.doLayout(container);
        FocusGroup focus = this.getFocusGroup();
        this.clinicianSelector = this.createClinicianSelector();
        container.add((Component)LabelFactory.create((String)"clinician"));
        container.add((Component)this.clinicianSelector);
        focus.add((Component)this.clinicianSelector);
        this.date = new DateSelector();
        this.date.setListener(new ActionListener(){

            public void onAction(ActionEvent event) {
                ScheduleServiceQuery.this.onDateChanged();
            }
        });
        this.date.setCurrentDateListener(new ActionListener(){

            public void onAction(ActionEvent event) {
                ScheduleServiceQuery.this.onCurrentDateSelected();
            }
        });
        this.highlightSelector = this.createHighlightSelector();
        this.updateHighlightField();
        container.add((Component)LabelFactory.create((String)"workflow.scheduling.query.date"));
        container.add(this.date.getComponent());
        container.add((Component)LabelFactory.create((String)"workflow.scheduling.highlight"));
        container.add((Component)this.highlightSelector);
        focus.add(this.date.getFocusGroup());
        focus.add((Component)this.highlightSelector);
    }

    protected void onDateChanged() {
        this.onQuery();
    }

    protected void onCurrentDateSelected() {
    }

    @Override
    protected void onViewChanged() {
        this.updateHighlightField();
        super.onViewChanged();
    }

    protected ScheduleService getService() {
        return this.service;
    }

    private Map<Entity, ScheduleEvents> getEvents() {
        Date date = this.getDate();
        LinkedHashMap<Entity, ScheduleEvents> result = new LinkedHashMap<Entity, ScheduleEvents>();
        for (Entity schedule : this.getSelectedSchedules()) {
            ScheduleEvents events = this.getEvents(schedule, date);
            result.put(schedule, events);
        }
        return result;
    }

    private SelectField createClinicianSelector() {
        ClinicianSelectField field = new ClinicianSelectField();
        field.setSelected(this.getDefaultClinician());
        field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                ScheduleServiceQuery.this.onQuery();
            }
        });
        return field;
    }

    private void updateHighlightField() {
        String code = null;
        ScheduleTableModel.Highlight highlight = this.getDefaultHighlight();
        if (highlight != null) {
            code = highlight.toString();
        } else {
            Entity view = this.getScheduleView();
            if (view != null) {
                IMObjectBean bean = IMObjectHelper.getBean((IMObject)view);
                code = bean.getString("highlight", ScheduleTableModel.Highlight.EVENT_TYPE.toString());
            }
        }
        this.highlightSelector.setSelectedItem((Object)code);
    }
}

