/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import echopointng.table.TableActionEventEx;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.TableModel;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.query.AbstractBrowser;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.echo.table.TableEx;
import org.openvpms.web.echo.util.DoubleClickMonitor;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleBrowserListener;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleQuery;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleServiceQuery;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;

public abstract class ScheduleBrowser
extends AbstractBrowser<PropertySet> {
    private final ScheduleServiceQuery query;
    private final Context context;
    private final DoubleClickMonitor click = new DoubleClickMonitor();
    private final ArchetypeService service;
    private Map<Entity, ScheduleEvents> results;
    private Component component;
    private TableEx table;
    private ScheduleTableModel model;
    private PropertySet selected;
    private Date selectedTime;
    private Entity selectedSchedule;
    private PropertySet marked;

    public ScheduleBrowser(ScheduleServiceQuery query, Context context) {
        this.query = query;
        this.context = context;
        this.service = ServiceHelper.getArchetypeService();
        query.setListener(new ScheduleQuery.ScheduleQueryListener(){

            @Override
            public void now() {
                ScheduleBrowser.this.onNow();
            }

            public void query() {
                ScheduleBrowser.this.onQuery();
            }
        });
    }

    public void query() {
        this.doQuery(true);
    }

    public PropertySet getSelected() {
        return this.selected;
    }

    public boolean setSelected(PropertySet object) {
        Cell cell;
        boolean found = false;
        this.selected = object;
        if (this.selected != null && (cell = this.model.getCell((Reference)object.getReference("schedule.objectReference"), (Reference)object.getReference("act.objectReference"))) != null) {
            Schedule schedule = this.model.getSchedule(cell);
            this.model.setSelected(cell);
            this.selectedTime = object.getDate("act.startTime");
            this.selectedSchedule = schedule.getSchedule();
            found = true;
        }
        if (!found) {
            this.model.setSelected(null);
            this.selectedTime = null;
            this.selectedSchedule = null;
            this.getTable().getSelectionModel().clearSelection();
        }
        return found;
    }

    public PropertySet getMarked() {
        return this.marked;
    }

    public void setMarked(PropertySet event, boolean isCut) {
        this.marked = event;
        this.updateMarked(isCut);
    }

    public void clearMarked() {
        this.setMarked(null, this.isCut());
    }

    public boolean isCut() {
        return this.model != null && this.model.isCut();
    }

    public void setDate(Date date) {
        this.query.setDate(date);
    }

    public Date getDate() {
        return this.query.getDate();
    }

    public void setScheduleView(Entity view) {
        this.query.setScheduleView(view);
    }

    public Entity getScheduleView() {
        return this.query.getScheduleView();
    }

    public Entity getSelectedSchedule() {
        return this.selectedSchedule;
    }

    public Date getSelectedTime() {
        return this.selectedTime;
    }

    public List<PropertySet> getObjects() {
        if (this.results == null) {
            this.query();
        }
        ArrayList<PropertySet> result = new ArrayList<PropertySet>();
        for (ScheduleEvents list : this.results.values()) {
            result.addAll(list.getEvents());
        }
        return result;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = this.doLayout();
        }
        return this.component;
    }

    public void addScheduleBrowserListener(ScheduleBrowserListener listener) {
        this.addBrowserListener(listener);
    }

    public Act getAct(PropertySet event) {
        if (event != null) {
            IMObjectReference actRef = event.getReference("act.objectReference");
            return (Act)IMObjectHelper.getObject((Reference)actRef);
        }
        return null;
    }

    public PropertySet getEvent(Act act) {
        ScheduleEvents events;
        Entity schedule;
        PropertySet result = null;
        if (act != null && (schedule = this.getSchedule(act)) != null && (events = this.results.get(schedule)) != null) {
            result = events.getEvent(act.getObjectReference());
        }
        return result;
    }

    public void setFocusOnResults() {
    }

    public void refresh() {
        if (this.results != null && this.query.updated(this.results)) {
            this.query();
        }
    }

    protected Entity getSchedule(Act act) {
        return (Entity)this.getBean((IMObject)act).getTarget("schedule", Entity.class);
    }

    protected IMObjectBean getBean(IMObject object) {
        return this.service.getBean(object);
    }

    protected ScheduleTableModel getModel() {
        return this.model;
    }

    protected TableEx getTable() {
        return this.table;
    }

    protected ScheduleServiceQuery getQuery() {
        return this.query;
    }

    protected abstract ScheduleEventGrid createEventGrid(Date var1, Map<Entity, ScheduleEvents> var2);

    protected abstract ScheduleTableModel createTableModel(ScheduleEventGrid var1);

    protected TableEx createTable(ScheduleTableModel model) {
        TableEx table = new TableEx((TableModel)model, model.getColumnModel()){

            protected void doRender() {
                ScheduleTableModel model = (ScheduleTableModel)this.getModel();
                model.preRender();
                try {
                    super.doRender();
                }
                finally {
                    model.postRender();
                }
            }
        };
        table.setStyleName("ScheduleTable");
        table.setHeaderFixed(true);
        return table;
    }

    protected Component doLayout() {
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{this.layoutQuery()});
        SplitPane component = SplitPaneFactory.create((int)5, (String)"ScheduleBrowser", (Component[])new Component[]{column});
        if (this.getScheduleView() != null && this.table != null) {
            this.addTable((Table)this.table, (Component)component);
        }
        return component;
    }

    protected Component layoutQuery() {
        return this.layoutQuery(this.query, new ActionListener(){

            public void onAction(ActionEvent event) {
                ScheduleBrowser.this.onQuery();
            }
        });
    }

    protected Component layoutQuery(ScheduleQuery query, ActionListener listener) {
        Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
        FocusGroup group = this.getFocusGroup();
        row.add(query.getComponent());
        group.add(query.getFocusGroup());
        ButtonRow buttons = new ButtonRow(group);
        buttons.addButton("query", (nextapp.echo2.app.event.ActionListener)listener);
        row.add((Component)buttons);
        return row;
    }

    protected void onQuery() {
        this.query();
        this.notifyBrowserListeners();
    }

    protected void onNow() {
    }

    protected void doQuery(boolean reselect) {
        this.getComponent();
        if (this.query.getScheduleView() != null) {
            this.doQueryWithView(reselect);
        } else {
            if (this.table != null) {
                this.component.remove((Component)this.table);
            }
            this.results = null;
            this.model = null;
            this.table = null;
        }
    }

    protected Context getContext() {
        return this.context;
    }

    protected void addTable(Table table, Component component) {
        component.add((Component)ColumnFactory.create((String)"InsetCellSpacing", (Component[])new Component[]{table}));
    }

    protected void setSelectedCell(Cell cell) {
        this.model.setSelected(cell);
        this.selected = this.model.getEvent(cell);
        if (this.model.getAvailability(cell) != ScheduleEventGrid.Availability.UNAVAILABLE) {
            Schedule schedule = this.model.getSchedule(cell);
            if (schedule != null) {
                this.selectedTime = this.model.getStartTime(schedule, cell);
                this.selectedSchedule = this.model.getScheduleEntity(cell);
            } else {
                this.selectedTime = null;
                this.selectedSchedule = null;
            }
        } else {
            this.selectedTime = null;
            this.selectedSchedule = null;
        }
    }

    protected void onSelected(TableActionEventEx event) {
        int column = event.getColumn();
        int row = event.getRow();
        boolean doubleClick = false;
        if (this.click.isDoubleClick()) {
            if (this.model.isSingleScheduleView()) {
                Cell cell = this.model.getSelected();
                if (cell != null && cell.getRow() == row) {
                    doubleClick = true;
                }
            } else if (this.model.isSelected(column, row)) {
                doubleClick = true;
            }
        }
        this.setSelectedCell(new Cell(column, row));
        if (doubleClick) {
            if (this.selected == null) {
                for (BrowserListener listener : this.getBrowserListeners()) {
                    if (!(listener instanceof ScheduleBrowserListener)) continue;
                    ((ScheduleBrowserListener)listener).create();
                }
            } else {
                for (BrowserListener listener : this.getBrowserListeners()) {
                    if (!(listener instanceof ScheduleBrowserListener)) continue;
                    ((ScheduleBrowserListener)listener).edit(this.selected);
                }
            }
        } else {
            this.notifySelected(this.selected);
        }
        if (!this.model.isSingleScheduleView()) {
            this.table.getSelectionModel().clearSelection();
        }
    }

    protected void restore(ScheduleTableModel.State state) {
        this.model.setState(state);
        if (this.model.getSelected() == null) {
            this.setSelected(null);
        }
    }

    private void doQueryWithView(boolean reselect) {
        this.results = this.query.query();
        ScheduleEventGrid grid = this.createEventGrid(this.query.getDate(), this.results);
        ScheduleTableModel.State state = null;
        if (this.model != null) {
            state = this.model.getState();
        }
        this.model = this.createTableModel(grid);
        if (this.table == null) {
            this.table = this.createTable(this.model);
            this.table.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    ScheduleBrowser.this.onSelected((TableActionEventEx)event);
                }
            });
            this.addTable((Table)this.table, this.component);
        } else {
            this.table.setModel((TableModel)this.model);
            this.table.setColumnModel(this.model.getColumnModel());
        }
        User clinician = this.query.getClinician();
        if (clinician != null) {
            this.model.setClinician(clinician.getObjectReference());
        } else {
            this.model.setClinician(null);
        }
        this.model.setHighlight(this.query.getHighlight());
        if (reselect && state != null) {
            this.restore(state);
        }
    }

    private void updateMarked(boolean isCut) {
        boolean found = false;
        ScheduleTableModel model = this.getModel();
        if (model != null) {
            IMObjectReference eventRef;
            IMObjectReference scheduleRef;
            Cell cell;
            if (this.marked != null && (cell = model.getCell((Reference)(scheduleRef = this.marked.getReference("schedule.objectReference")), (Reference)(eventRef = this.marked.getReference("act.objectReference")))) != null) {
                model.setMarked(cell, isCut);
                found = true;
            }
            if (!found) {
                model.setMarked(null, isCut);
            }
        }
    }
}

