/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import java.util.Objects;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.bound.BoundDateTimeField;
import org.openvpms.web.component.bound.BoundDateTimeFieldFactory;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.customer.CustomerParticipationEditor;
import org.openvpms.web.component.im.edit.act.AbstractActEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientParticipationEditor;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.DateTimePropertyTransformer;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.system.ServiceHelper;

public class AbstractScheduleActEditor
extends AbstractActEditor {
    protected static final String CUSTOMER = "customer";
    protected static final String PATIENT = "patient";
    private final PatientRules rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
    private final BoundDateTimeField startTime = this.createDateTime("startTime");
    private final BoundDateTimeField endTime = this.createDateTime("endTime");
    private final ModifiableListener customerListener = modifiable -> this.onCustomerChanged();
    private final ModifiableListener patientListener = modifiable -> this.onPatientChanged();

    public AbstractScheduleActEditor(Act act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
    }

    public void setCustomer(Party customer) {
        this.getCustomerEditor().setEntity((Entity)customer);
    }

    public Party getCustomer() {
        return (Party)this.getParticipant(CUSTOMER);
    }

    public Party getPatient() {
        return (Party)this.getParticipant(PATIENT);
    }

    public void setPatient(Party patient) {
        this.setParticipant(PATIENT, (Entity)patient);
    }

    public void setClinician(User clinician) {
        this.setParticipant("clinician", (Entity)clinician);
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategy strategy = super.createLayoutStrategy();
        strategy.addComponent(new ComponentState((PropertyEditor)this.startTime));
        strategy.addComponent(new ComponentState((PropertyEditor)this.endTime));
        return strategy;
    }

    protected void onLayoutCompleted() {
        if (this.getProperty(CUSTOMER) != null && this.getProperty(PATIENT) != null) {
            CustomerParticipationEditor customer = this.getCustomerEditor();
            PatientParticipationEditor patient = this.getPatientEditor();
            if (customer != null) {
                customer.setPatientParticipationEditor(patient);
                customer.addModifiableListener(this.customerListener);
            }
            if (patient != null) {
                patient.addModifiableListener(this.patientListener);
            }
        }
    }

    protected BoundDateTimeField getStartTimeEditor() {
        return this.startTime;
    }

    protected BoundDateTimeField getEndTimeEditor() {
        return this.endTime;
    }

    protected PatientParticipationEditor getPatientEditor() {
        ParticipationEditor result = this.getParticipationEditor(PATIENT, true);
        return (PatientParticipationEditor)result;
    }

    protected CustomerParticipationEditor getCustomerEditor() {
        ParticipationEditor result = this.getParticipationEditor(CUSTOMER, true);
        return (CustomerParticipationEditor)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCustomerChanged() {
        block7: {
            try {
                Party customer = this.getCustomer();
                Party patient = this.getPatient();
                if (customer == null || patient == null || this.rules.isOwner(customer, patient)) break block7;
                PatientParticipationEditor patientEditor = this.getPatientEditor();
                try {
                    if (patientEditor != null) {
                        patientEditor.removeModifiableListener(this.patientListener);
                    }
                    this.setPatient(null);
                }
                finally {
                    if (patientEditor != null) {
                        patientEditor.addModifiableListener(this.patientListener);
                    }
                }
            }
            catch (OpenVPMSException exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPatientChanged() {
        block7: {
            try {
                Party owner;
                Party customer = this.getCustomer();
                Party patient = this.getPatient();
                if (customer == null || patient == null || Objects.equals(owner = this.rules.getOwner(patient), customer)) break block7;
                CustomerParticipationEditor customerEditor = this.getCustomerEditor();
                try {
                    if (customerEditor != null) {
                        customerEditor.removeModifiableListener(this.customerListener);
                    }
                    this.setCustomer(owner);
                }
                finally {
                    if (customerEditor != null) {
                        customerEditor.addModifiableListener(this.customerListener);
                    }
                }
            }
            catch (OpenVPMSException exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
    }

    protected BoundDateTimeField createDateTime(String name) {
        Property property = this.getProperty(name);
        BoundDateTimeField field = BoundDateTimeFieldFactory.create((Property)property);
        DateTimePropertyTransformer transformer = (DateTimePropertyTransformer)property.getTransformer();
        transformer.setKeepSeconds(false);
        return field;
    }
}

