/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import java.util.Date;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.table.AbstractCellTableModel;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.echo.table.StyleTableCellRenderer;
import org.openvpms.web.echo.table.TableColumnFactory;
import org.openvpms.web.workspace.admin.calendar.CalendarHeaderCellRenderer;
import org.openvpms.web.workspace.workflow.roster.RosterEventGrid;
import org.openvpms.web.workspace.workflow.roster.RosterTableCellRenderer;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;

abstract class RosterTableModel
extends AbstractCellTableModel {
    public static final int NAME_INDEX = 0;
    private final RosterEventGrid grid;
    private final ScheduleColours colours;
    private Date date;
    private static final int FIRST_DAY_INDEX = 1;
    private static final StyleTableCellRenderer NAME_HEADER_RENDERER = new StyleTableCellRenderer("h3");
    private static final StyleTableCellRenderer NAME_CELL_RENDERER = new StyleTableCellRenderer("bold");

    RosterTableModel(RosterEventGrid grid, String nameKey, String entityKey, Context context, ScheduleColours colours) {
        this.grid = grid;
        this.colours = colours;
        this.setTableColumnModel(this.createColumnModel(nameKey, entityKey, context));
        this.setStartDate(grid.getStartDate());
    }

    public Date getStartDate() {
        return this.date;
    }

    public int getRowCount() {
        return this.getGrid().getRows();
    }

    public Object getValueAt(int column, int row) {
        TableColumn col = this.getColumn(column);
        if (col == null) {
            throw new IllegalArgumentException("Illegal column=" + column);
        }
        return this.getValueAt(col, row);
    }

    public PropertySet getEvent(Cell cell) {
        PropertySet result = null;
        int column = cell.getColumn();
        int row = cell.getRow();
        if (column >= 1 && row >= 0 && row < this.grid.getRows()) {
            int slot = column - 1;
            result = this.grid.getEvent(slot, row);
        }
        return result;
    }

    public abstract Cell getCell(PropertySet var1);

    public Entity getSelectedEntity() {
        Cell cell = this.getSelected();
        return cell != null && cell.getColumn() >= 1 ? this.grid.getEntity(cell.getRow()) : null;
    }

    public Date getSelectedDate() {
        Cell cell = this.getSelected();
        return cell != null && cell.getColumn() >= 1 ? DateRules.getDate((Date)this.date, (int)(cell.getColumn() - 1), (DateUnits)DateUnits.DAYS) : null;
    }

    public Date getDate(int column) {
        int day = this.getColumn(column).getModelIndex() - 1;
        return DateRules.getDate((Date)this.date, (int)day, (DateUnits)DateUnits.DAYS);
    }

    public ScheduleColours getColours() {
        return this.colours;
    }

    protected TableColumnModel createColumnModel(String nameKey, String entityKey, Context context) {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        int days = this.grid.getColumns();
        TableColumn name = TableColumnFactory.createKey((int)0, (String)nameKey, (TableCellRenderer)NAME_HEADER_RENDERER, (TableCellRenderer)NAME_CELL_RENDERER);
        name.setWidth(new Extent(18, 2));
        Extent width = new Extent(100 - 18 / days);
        model.addColumn(name);
        RosterTableCellRenderer renderer = new RosterTableCellRenderer(entityKey, this, context);
        for (int i = 0; i < days; ++i) {
            TableColumn column = TableColumnFactory.create((int)(1 + i), (TableCellRenderer)CalendarHeaderCellRenderer.INSTANCE, (TableCellRenderer)renderer);
            column.setWidth(width);
            model.addColumn(column);
        }
        return model;
    }

    protected Cell getCell(Reference entity, Reference event) {
        Cell result = null;
        int row = this.grid.findEntity(entity);
        while (row != -1) {
            int column = this.grid.findEvent(row, event);
            if (column == -1) {
                row = this.grid.findEntity(row + 1, entity);
                continue;
            }
            result = new Cell(column + 1, row);
            break;
        }
        return result;
    }

    protected RosterEventGrid getGrid() {
        return this.grid;
    }

    protected Object getValueAt(TableColumn column, int row) {
        String result;
        if (column.getModelIndex() == 0) {
            result = this.getEntity(row);
        } else {
            int slot = column.getModelIndex() - 1;
            result = this.grid.getEvent(slot, row);
        }
        return result;
    }

    protected String getEntity(int row) {
        String result = null;
        RosterEventGrid grid = this.getGrid();
        Entity entity = grid.getEntity(row);
        if (row == 0 || !entity.equals(grid.getEntity(row - 1))) {
            result = entity.getName();
        }
        return result;
    }

    private void setStartDate(Date date) {
        if (date == null || !DateRules.dateEquals((Date)date, (Date)this.date)) {
            this.date = date;
            DefaultTableColumnModel model = (DefaultTableColumnModel)this.getColumnModel();
            for (int i = 0; i < this.grid.getColumns(); ++i) {
                int index = 1 + i;
                TableColumn column = model.getColumn(index);
                column.setHeaderValue((Object)this.getDate(index));
            }
            this.fireTableDataChanged();
        }
    }
}

