/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.workspace.admin.calendar.CalendarEventEditor;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditor;
import org.openvpms.web.workspace.workflow.roster.AreaParticipationEditor;

public class RosterEventEditor
extends CalendarEventEditor {
    private int duration;

    public RosterEventEditor(Act act, IMObject parent, LayoutContext context) {
        super(act, parent, false, context);
        this.calculateDuration();
        if (act.isNew()) {
            if (this.getStartTime() == null) {
                this.setStartTime(DateRules.getDate((Date)DateRules.getToday(), (int)9, (DateUnits)DateUnits.HOURS));
            }
            this.initParticipant("location", (IMObject)context.getContext().getLocation());
        }
    }

    @Override
    public IMObjectEditor newInstance() {
        return new RosterEventEditor((Act)this.reload((IMObject)this.getObject()), this.getParent(), this.getLayoutContext());
    }

    public void setUser(User user) {
        this.setParticipant("user", (Entity)user);
    }

    public User getUser() {
        return (User)this.getParticipant("user");
    }

    @Override
    protected int getSlotSize(Entity schedule) {
        return 1;
    }

    protected void onModified(Modifiable modifiable) {
        super.onModified(modifiable);
        this.updateSynchronisation();
    }

    @Override
    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        Party location = (Party)this.getParticipant("location");
        AreaParticipationEditor area = this.getAreaEditor();
        area.setLocation(location);
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new RosterLayoutStrategy();
    }

    @Override
    protected Date getDefaultStartTime(Date date) {
        return DateRules.getDate((Date)date, (int)8, (DateUnits)DateUnits.HOURS);
    }

    @Override
    protected void calculateEndTime() {
        Date start = this.getStartTime();
        if (start != null) {
            Date end = this.getEndTime();
            if (end == null || DateRules.compareTo((Date)start, (Date)end) >= 0) {
                end = DateRules.getDate((Date)start, (int)this.duration, (DateUnits)DateUnits.MINUTES);
                this.setEndTime(end);
            } else {
                this.calculateDuration();
            }
        }
    }

    @Override
    protected void onEndTimeChanged() {
        super.onEndTimeChanged();
        this.calculateDuration();
    }

    private void calculateDuration() {
        Date startTime = this.getStartTime();
        Date endTime = this.getEndTime();
        this.duration = startTime != null && endTime != null ? DateRules.minutesBetween((Date)startTime, (Date)endTime) : 480;
    }

    private void updateSynchronisation() {
        CollectionProperty synchronisation = this.getCollectionProperty("synchronisation");
        if (synchronisation != null) {
            for (Object value : synchronisation.getValues()) {
                IMObjectBean bean = this.getBean((IMObject)value);
                if (!bean.hasNode("status")) continue;
                bean.setValue("status", (Object)"PENDING");
            }
        }
    }

    private AreaParticipationEditor getAreaEditor() {
        return (AreaParticipationEditor)this.getParticipationEditor("schedule", false);
    }

    private class RosterLayoutStrategy
    extends AbstractCalendarEventEditor.LayoutStrategy {
        public RosterLayoutStrategy() {
            this.getArchetypeNodes().simple(new String[]{"error"}).excludeIfEmpty(new String[]{"error"});
        }
    }
}

