/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.util.PropertySet;

class EntityRoster<T extends Entity> {
    private final LocalDate startDate;
    private final int days;
    private final T entity;
    private final List<List<PropertySet>> events = new ArrayList<List<PropertySet>>();

    EntityRoster(T entity, Date start, int days, List<PropertySet> events) {
        this.startDate = DateRules.toLocalDate((Date)start);
        this.days = days;
        this.entity = entity;
        if (events.isEmpty()) {
            this.events.add(Collections.emptyList());
        } else {
            for (PropertySet event : events) {
                this.addEvent(event);
            }
            this.events.add(Collections.emptyList());
        }
    }

    public T getEntity() {
        return this.entity;
    }

    public List<List<PropertySet>> getEvents() {
        return this.events;
    }

    private void addEvent(PropertySet event) {
        int startDay = this.getStartDay(event);
        int endDay = this.getEndDay(event);
        List<PropertySet> row = null;
        for (int i = startDay; i <= endDay && i < this.days; ++i) {
            for (List<PropertySet> list : this.events) {
                if (list.get(i) != null) continue;
                row = list;
                break;
            }
            if (row == null) {
                row = new ArrayList<Object>(Collections.nCopies(this.days, null));
                this.events.add(row);
            }
            row.set(i, event);
        }
    }

    private int getStartDay(PropertySet event) {
        LocalDate startTime = DateRules.toLocalDate((Date)event.getDate("act.startTime"));
        return (int)ChronoUnit.DAYS.between(this.startDate, startTime);
    }

    private int getEndDay(PropertySet event) {
        LocalDate endTime = DateRules.toLocalDate((Date)event.getDate("act.endTime"));
        return (int)ChronoUnit.DAYS.between(this.startDate, endTime);
    }
}

