/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.otc;

import java.util.Arrays;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.PracticeMailContext;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.PrintActTask;
import org.openvpms.web.component.workflow.PrintIMObjectTask;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.WorkflowException;
import org.openvpms.web.workspace.workflow.i18n.WorkflowMessages;
import org.openvpms.web.workspace.workflow.otc.OTCChargeTask;
import org.openvpms.web.workspace.workflow.otc.OTCPaymentTask;

public class OverTheCounterWorkflow
extends WorkflowImpl {
    private final TaskContext initial;

    public OverTheCounterWorkflow(final Context parent, HelpContext help) {
        super(help);
        if (parent.getPractice() == null) {
            throw new WorkflowException(WorkflowMessages.contextHasNoPractice());
        }
        this.initial = new DefaultTaskContext(null, help);
        Party location = parent.getLocation();
        if (location == null) {
            throw new WorkflowException(WorkflowMessages.contextHasNoLocation());
        }
        IMObjectBean bean = this.getBean((IMObject)location);
        Party otc = (Party)bean.getTarget("OTC", Party.class);
        if (otc == null) {
            throw new WorkflowException(WorkflowMessages.locationHasNoOTCCustomer(location));
        }
        this.initial.setCustomer(otc);
        this.initial.setTill(parent.getTill());
        this.initial.setTerminal(parent.getTerminal());
        this.initial.setLocation(parent.getLocation());
        this.initial.setPractice(parent.getPractice());
        this.initial.setUser(parent.getUser());
        EditIMObjectTask charge = this.createChargeTask();
        charge.setDeleteOnCancelOrSkip(true);
        this.addTask((Task)charge);
        EditIMObjectTask payment = this.createPaymentTask();
        payment.setDeleteOnCancelOrSkip(true);
        this.addTask((Task)payment);
        this.addTask((Task)new SynchronousTask(){

            public void execute(TaskContext context) {
                Act charge = (Act)context.getObject("act.customerAccountChargesCounter");
                Act payment = (Act)context.getObject("act.customerAccountPayment");
                charge.setStatus("POSTED");
                payment.setStatus("POSTED");
                ServiceHelper.getArchetypeService().save(Arrays.asList(charge, payment));
            }
        });
        PrintIMObjectTask printTask = this.createPrintTask(parent);
        printTask.setRequired(false);
        this.addTask((Task)printTask);
        this.addTask((Task)new SynchronousTask(){

            public void execute(TaskContext context) {
                parent.setTill(context.getTill());
                parent.setTerminal(context.getTerminal());
                if (!UserHelper.useLoggedInClinician((Context)context)) {
                    parent.setClinician(context.getClinician());
                }
            }
        });
        this.setBreakOnSkip(true);
    }

    public void start() {
        super.start(this.initial);
    }

    protected EditIMObjectTask createChargeTask() {
        return new OTCChargeTask();
    }

    protected EditIMObjectTask createPaymentTask() {
        return new OTCPaymentTask();
    }

    protected PrintIMObjectTask createPrintTask(Context parent) {
        return new PrintActTask("act.customerAccountChargesCounter", (MailContext)new PracticeMailContext(parent));
    }
}

