/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.otc;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.delete.DefaultIMObjectDeletionListener;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.delete.IMObjectDeletionListener;
import org.openvpms.web.component.im.delete.SilentIMObjectDeleter;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.otc.OTCPaymentEditor;

class OTCPaymentTask
extends EditIMObjectTask {
    public OTCPaymentTask() {
        super("act.customerAccountPayment", true);
    }

    protected void edit(IMObject object, TaskContext context) {
        Act payment = (Act)object;
        payment.setStatus("IN_PROGRESS");
        super.edit(object, context);
    }

    protected void delete(IMObject object, TaskContext context, Runnable callback) {
        Runnable onSuccess = () -> {
            this.removeCharge(context);
            callback.run();
        };
        super.delete(object, context, onSuccess, callback);
    }

    protected IMObjectEditor createEditor(IMObject object, TaskContext context) {
        DefaultLayoutContext layout = new DefaultLayoutContext(true, (Context)context, context.getHelpContext());
        FinancialAct charge = (FinancialAct)context.getObject("act.customerAccountChargesCounter");
        return new OTCPaymentEditor((FinancialAct)object, null, (LayoutContext)layout, charge.getTotal());
    }

    private void removeCharge(TaskContext context) {
        IMObject charge = context.getObject("act.customerAccountChargesCounter");
        if ((charge = IMObjectHelper.reload((IMObject)charge)) != null) {
            IMObjectDeletionHandlerFactory factory = (IMObjectDeletionHandlerFactory)ServiceHelper.getBean(IMObjectDeletionHandlerFactory.class);
            SilentIMObjectDeleter deleter = new SilentIMObjectDeleter(factory, (ArchetypeService)ServiceHelper.getArchetypeService());
            deleter.delete(charge, (Context)context, context.getHelpContext(), (IMObjectDeletionListener)new DefaultIMObjectDeletionListener());
        }
    }
}

