/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.sms;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.messaging.sms.AbstractSMSMessageLayoutStrategy;

public class SMSMessageLayoutStrategy
extends AbstractSMSMessageLayoutStrategy {
    private static final String STATUS = "status";
    private static final String STATUS_MESSAGE = "statusMessage";
    private static final String EXPIRY_TIME = "expiryTime";
    private static final String REPLIES = "replies";
    private static final String SOURCE = "source";

    public SMSMessageLayoutStrategy() {
        this(true);
    }

    public SMSMessageLayoutStrategy(boolean showPatient) {
        super(showPatient, "createdTime");
        ArchetypeNodes nodes = ArchetypeNodes.all().exclude(new String[]{"contact", STATUS_MESSAGE}).excludeIfEmpty(new String[]{EXPIRY_TIME, REPLIES});
        this.setArchetypeNodes(nodes);
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Reference reference;
        Property statusMessage = properties.get(STATUS_MESSAGE);
        if (!StringUtils.isEmpty((CharSequence)statusMessage.getString())) {
            this.addComponent(this.createMultiLineText(statusMessage, 1, 3, new Extent(50, 128), context));
            this.addComponent(this.createComponentPair(STATUS, STATUS_MESSAGE, object, properties, context));
        }
        this.getArchetypeNodes().exclude(new String[]{SOURCE});
        if (!context.isEdit() && context.getContextSwitchListener() != null && (reference = this.getBean(object).getSourceRef(SOURCE)) != null && reference.isA("act.customerAppointment")) {
            String name = Messages.format((String)"imobject.link", (Object[])new Object[]{this.getDisplayName(reference.getArchetype())});
            IMObjectReferenceViewer viewer = new IMObjectReferenceViewer(reference, name, context.getContextSwitchListener(), context.getContext());
            this.addComponent(new ComponentState(viewer.getComponent(), properties.get(SOURCE)));
        }
        return super.apply(object, properties, parent, context);
    }

    @Override
    protected List<Property> getTextProperties(List<Property> properties, Property message) {
        Property status;
        List<Property> result = super.getTextProperties(properties, message);
        if (this.getComponent(STATUS) != null && (status = ArchetypeNodes.find(properties, (String)STATUS)) != null) {
            result.add(0, status);
        }
        return result;
    }

    @Override
    protected void addTextComponents(ComponentGrid grid, ComponentSet components) {
        super.addTextComponents(grid, components);
        ComponentState source = this.getComponent(SOURCE);
        if (source != null) {
            grid.add(new Component[]{source.getComponent()});
        }
    }
}

