/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.sms;

import java.util.List;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.lang.StringUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableModel;

public class AbstractSMSTableModel
extends DescriptorTableModel<Act> {
    private int contactIndex;
    private int customerIndex;
    private int patientIndex;
    private int locationIndex;
    private int messageIndex;
    static final String CONTACT = "contact";
    static final String MESSAGE = "message";
    static final String CUSTOMER = "customer";
    static final String PATIENT = "patient";
    static final String LOCATION = "location";

    public AbstractSMSTableModel(String archetype, LayoutContext context) {
        super(new String[]{archetype}, context);
    }

    protected TableColumnModel createColumnModel(List<ArchetypeDescriptor> archetypes, LayoutContext context) {
        TableColumnModel model = super.createColumnModel(archetypes, context);
        this.contactIndex = this.getModelIndex(model, CONTACT);
        this.messageIndex = this.getModelIndex(model, MESSAGE);
        this.customerIndex = this.getModelIndex(model, CUSTOMER);
        this.patientIndex = this.getModelIndex(model, PATIENT);
        this.locationIndex = this.getModelIndex(model, LOCATION);
        return model;
    }

    protected ArchetypeNodes getArchetypeNodes() {
        return ArchetypeNodes.nodes((String[])new String[]{"startTime", CONTACT, "phone", "status", MESSAGE, CUSTOMER, PATIENT, "reason", LOCATION});
    }

    protected Object getValue(Act object, TableColumn column, int row) {
        int index = column.getModelIndex();
        Object result = index == this.contactIndex ? this.createViewer(object, CONTACT, true) : (index == this.messageIndex ? this.getMessage(object) : (index == this.customerIndex ? this.createViewer(object, CUSTOMER, true) : (index == this.patientIndex ? this.createViewer(object, PATIENT, true) : (index == this.locationIndex ? this.createViewer(object, LOCATION, false) : super.getValue((IMObject)object, column, row)))));
        return result;
    }

    private Object getMessage(Act object) {
        IMObjectBean bean = this.getCurrent((IMObject)object);
        return StringUtils.abbreviate((String)bean.getString(MESSAGE), (int)20);
    }
}

