/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.sms;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.location.LocationSelectField;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.workspace.workflow.messaging.sms.SMSResultSet;

public abstract class AbstractSMSQuery
extends DateRangeActQuery<Act> {
    private final LocationSelectField location;

    public AbstractSMSQuery(String archetype, ActStatuses statuses, LayoutContext context) {
        super(null, null, null, new String[]{archetype}, statuses, Act.class);
        this.location = this.createLocationSelector(context.getContext());
        this.setAuto(true);
        this.setContains(true);
        this.setDefaultSortConstraint(DESCENDING_START_TIME);
    }

    public void setLocation(Party location) {
        this.location.setSelectedItem((Object)location);
    }

    public Extent getHeight() {
        return this.getHeight(2);
    }

    protected ResultSet<Act> createResultSet(SortConstraint[] sort) {
        Party location = (Party)this.location.getSelectedItem();
        String[] statuses = this.getStatuses();
        return new SMSResultSet(this.getArchetypeConstraint(), this.getValue(), location, this.getLocations(), this.getFrom(), this.getTo(), statuses, this.getMaxResults(), sort);
    }

    protected List<Party> getLocations() {
        return this.location.getLocations();
    }

    protected Component createContainer() {
        return GridFactory.create((int)6);
    }

    protected void doLayout(Component container) {
        this.addSearchField(container);
        this.addStatusSelector(container);
        this.addDateRange(container);
        this.addLocation(container);
    }

    protected LocationSelectField createLocationSelector(Context context) {
        LocationSelectField result = new LocationSelectField(context.getUser(), context.getPractice(), true);
        result.setSelectedItem((Object)context.getLocation());
        result.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AbstractSMSQuery.this.onQuery();
            }
        });
        return result;
    }

    private void addLocation(Component container) {
        Label label = LabelFactory.text((String)DescriptorHelper.getDisplayName((String)"act.smsMessage", (String)"location", (ArchetypeService)this.getService()));
        container.add((Component)label);
        container.add((Component)this.location);
        this.getFocusGroup().add((Component)this.location);
    }
}

