/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.sms;

import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.workspace.customer.communication.AbstractCommunicationLayoutStrategy;

public class AbstractSMSMessageLayoutStrategy
extends AbstractCommunicationLayoutStrategy {
    protected static final String CONTACT = "contact";
    protected static final String CUSTOMER = "customer";
    protected static final String PHONE = "phone";
    protected static final String CREATED_TIME = "createdTime";

    public AbstractSMSMessageLayoutStrategy(boolean showPatient, String createdTime) {
        super(showPatient, null, createdTime);
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        IMObjectBean bean;
        Property recipient = properties.get(CONTACT);
        Property phone = properties.get(PHONE);
        if (!context.isEdit() && Objects.equals((bean = this.getBean(object)).getTargetRef(CONTACT), bean.getTargetRef(CUSTOMER))) {
            this.getArchetypeNodes().exclude(new String[]{CUSTOMER});
        }
        Component partyComponent = this.createComponent(recipient, object, context).getComponent();
        Component phoneComponent = this.createComponent(phone, object, context).getComponent();
        this.addComponent(new ComponentState((Component)RowFactory.create((String)"CellSpacing", (Component[])new Component[]{partyComponent, phoneComponent}), phone));
        return super.apply(object, properties, parent, context);
    }

    @Override
    protected List<Property> getHeaderProperties(List<Property> properties) {
        return ArchetypeNodes.include(properties, (String[])new String[]{PHONE, "description"});
    }

    @Override
    protected List<Property> getPatientProperties(List<Property> properties) {
        return ArchetypeNodes.include(properties, (String[])new String[]{"location", CUSTOMER, "patient"});
    }

    @Override
    protected List<Property> excludeEmptyFields(List<Property> properties) {
        return this.excludeIfEmpty(properties, "reason");
    }

    @Override
    protected ComponentState createMessage(Property property, LayoutContext context) {
        return this.createMultiLineText(property, 3, 20, Styles.FULL_WIDTH, context);
    }
}

