/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.messages;

import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.text.TextComponent;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.filter.NodeFilter;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.workspace.workflow.messaging.messages.AbstractMessageLayoutStrategy;

public class UserMessageLayoutStrategy
extends AbstractMessageLayoutStrategy {
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        if (!object.isNew()) {
            ComponentState from = this.createComponent(properties.get("from"), object, context);
            this.addComponent(from);
        }
        ComponentState to = this.createComponent(properties.get("to"), object, context);
        ComponentState description = this.createComponent(properties.get("description"), object, context);
        ComponentState message = this.createMessage(properties, context, "UserMessage.message");
        if (description.getComponent() instanceof TextComponent) {
            ((TextComponent)description.getComponent()).setWidth(Styles.FULL_WIDTH);
        }
        this.addComponent(to);
        this.addComponent(description);
        this.addComponent(message);
        return super.apply(object, properties, parent, context);
    }

    protected void doLayout(IMObject object, PropertySet properties, IMObject parent, Component container, LayoutContext context) {
        ArchetypeDescriptor archetype = context.getArchetypeDescriptor(object);
        ArchetypeNodes nodes = this.getArchetypeNodes();
        NodeFilter filter = this.getNodeFilter(object, context);
        List simple = nodes.getSimpleNodes(properties, (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, object, filter);
        List complex = nodes.getComplexNodes(properties, (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, object, filter);
        List from = !object.isNew() ? ArchetypeNodes.include((List)simple, (String[])new String[]{"from"}) : Collections.emptyList();
        List header = ArchetypeNodes.include((List)simple, (String[])new String[]{"to", "description"});
        List customer = ArchetypeNodes.include((List)simple, (String[])new String[]{"customer", "patient"});
        List fields = ArchetypeNodes.exclude((List)simple, (String[])new String[]{"from", "to", "description", "startTime", "customer", "patient", "message", "status"});
        if (!context.isEdit()) {
            IMObjectBean bean = this.getBean(object);
            if (bean.getTargetRef("customer") == null) {
                customer = ArchetypeNodes.exclude((List)customer, (String[])new String[]{"customer"});
            }
            if (bean.getTargetRef("patient") == null) {
                customer = ArchetypeNodes.exclude((List)customer, (String[])new String[]{"patient"});
            }
        }
        List message = ArchetypeNodes.include((List)simple, (String[])new String[]{"message"});
        ComponentGrid componentGrid = new ComponentGrid();
        if (!from.isEmpty()) {
            ComponentSet fromSet = this.createComponentSet(object, from, context);
            componentGrid.add(fromSet);
        }
        ComponentSet headerSet = this.createComponentSet(object, header, context);
        ComponentSet customerSet = this.createComponentSet(object, customer, context);
        ComponentSet fieldSet = this.createComponentSet(object, fields, context);
        ComponentSet messageSet = this.createComponentSet(object, message, context);
        if (!context.isEdit()) {
            componentGrid.set(0, 3, ComponentGrid.layout((Alignment)Alignment.ALIGN_RIGHT), (Component)this.createDate((Act)object));
        }
        componentGrid.add(headerSet, 1, 2);
        if (customerSet.size() != 0) {
            int columns = context.isEdit() ? customerSet.size() : 1;
            componentGrid.add(customerSet, columns);
        }
        componentGrid.add(fieldSet, 2);
        componentGrid.add(messageSet, 1, 2);
        Grid grid = this.createGrid(componentGrid);
        grid.setWidth(Styles.FULL_WIDTH);
        Column child = ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{grid});
        this.doComplexLayout(object, parent, complex, (Component)child, context);
        container.add((Component)child);
    }
}

