/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.messages;

import java.util.Date;
import org.openvpms.archetype.rules.act.DefaultActCopyHandler;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.AbstractIMObjectActions;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.AbstractViewCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.workflow.messaging.messages.UserMessageEditor;

public class MessagingCRUDWindow
extends AbstractViewCRUDWindow<Act> {
    static final String REPLY_ID = "reply";
    static final String FORWARD_ID = "forward";
    static final String COMPLETED_ID = "button.messagecompleted";
    private static final Archetypes<Act> MESSAGES = Archetypes.create((String)"act.userMessage", Act.class);

    public MessagingCRUDWindow(Archetypes<Act> archetypes, Context context, HelpContext help) {
        super(archetypes, (IMObjectActions)Actions.INSTANCE, context, help);
    }

    public void create() {
        this.onCreate(MESSAGES);
    }

    public MailContext getMailContext() {
        Object context = null;
        if (this.getObject() != null) {
            context = CustomerMailContext.create((Act)this.getObject(), this.getContext(), this.getHelpContext());
        }
        if (context == null) {
            context = super.getMailContext();
        }
        return context;
    }

    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(this.createNewButton());
        buttons.add(REPLY_ID, this::onReply);
        buttons.add(FORWARD_ID, this::onForward);
        buttons.add(this.createDeleteButton());
        buttons.add(COMPLETED_ID, this::onCompleted);
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        boolean user = TypeHelper.isA((IMObject)this.getObject(), (String)"act.userMessage");
        buttons.setEnabled(REPLY_ID, enable && user);
        buttons.setEnabled(FORWARD_ID, enable && user);
        buttons.setEnabled(COMPLETED_ID, enable);
        this.enablePrintPreview(buttons, enable);
    }

    protected void onSaved(Act object, boolean isNew) {
        this.onRefresh((IMObject)object);
    }

    private void onReply() {
        Act reply = this.copyObject();
        IMObjectBean bean = this.getBean((IMObject)reply);
        bean.setTarget("to", reply.getCreatedBy());
        HelpContext help = this.getHelpContext().subtopic(REPLY_ID).topic((IMObject)reply, "edit");
        LayoutContext layoutContext = this.createLayoutContext(help);
        UserMessageEditor editor = new UserMessageEditor(reply, null, layoutContext);
        Message message = new Message(this.getBean(this.getObject()));
        editor.setFrom(layoutContext.getContext().getUser());
        String subject = Messages.format((String)"workflow.messaging.reply.subject", (Object[])new Object[]{message.getSubject()});
        String text = Messages.format((String)"workflow.messaging.reply.body", (Object[])new Object[]{message.getSent(), message.getFromName(), message.getMessage()});
        editor.setSubject(subject);
        editor.setMessage(text);
        this.edit((IMObjectEditor)editor, Messages.get((String)"workflow.messaging.reply.title"));
    }

    private void onForward() {
        Act forward = this.copyObject();
        IMObjectBean bean = this.getBean((IMObject)forward);
        bean.setTarget("to", (Reference)null);
        HelpContext help = this.getHelpContext().subtopic(FORWARD_ID).topic((IMObject)forward, "edit");
        LayoutContext layoutContext = this.createLayoutContext(help);
        UserMessageEditor editor = new UserMessageEditor(forward, null, layoutContext);
        Message message = new Message(this.getBean(this.getObject()));
        String subject = Messages.format((String)"workflow.messaging.forward.subject", (Object[])new Object[]{message.getSubject()});
        String text = Messages.format((String)"workflow.messaging.forward.body", (Object[])new Object[]{message.getSubject(), message.getSent(), message.getFromName(), message.getToName(), message.getMessage()});
        editor.setSubject(subject);
        editor.setMessage(text);
        this.edit((IMObjectEditor)editor, Messages.get((String)"workflow.messaging.forward.title"));
    }

    private void edit(IMObjectEditor editor, String title) {
        EditDialog dialog = this.edit(editor);
        if (dialog != null) {
            dialog.setTitle(title);
        }
    }

    private void onCompleted() {
        Act act = (Act)this.getObject();
        if (!"COMPLETED".equals(act.getStatus())) {
            if ((act = (Act)IMObjectHelper.reload((IMObject)act)) != null) {
                act.setStatus("COMPLETED");
                SaveHelper.save((IMObject)act);
            }
            this.onRefresh((IMObject)act);
        }
    }

    private Act copyObject() {
        DefaultActCopyHandler handler = new DefaultActCopyHandler();
        handler.setCopy(new Class[]{Act.class, Participation.class});
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)handler, (ArchetypeService)ServiceHelper.getArchetypeService());
        return (Act)copier.apply(this.getObject()).get(0);
    }

    private static class Actions
    extends AbstractIMObjectActions<Act> {
        public static final Actions INSTANCE = new Actions();

        private Actions() {
        }

        public boolean canDelete(Act object) {
            return super.canDelete((IMObject)object) && !TypeHelper.isA((IMObject)object, (String)"act.auditMessage");
        }
    }

    private static class Message {
        private final IMObjectBean bean;

        public Message(IMObjectBean bean) {
            this.bean = bean;
        }

        public User getFrom() {
            return (User)this.bean.getObject("from");
        }

        public User getTo() {
            return (User)this.bean.getTarget("to", User.class);
        }

        public String getSubject() {
            return this.bean.getString("description", "");
        }

        public String getMessage() {
            return this.bean.getString("message", "");
        }

        public String getFromName() {
            User from = this.getFrom();
            return from != null ? from.getName() : "";
        }

        public String getToName() {
            User to = this.getTo();
            return to != null ? to.getName() : null;
        }

        public String getSent() {
            return DateFormatter.formatDateTime((Date)this.bean.getDate("startTime"));
        }
    }
}

