/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.investigation;

import java.util.List;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.app.DefaultContextSwitchListener;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.component.workspace.ResultSetCRUDWorkspace;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.CustomerPatientSummary;
import org.openvpms.web.workspace.patient.summary.CustomerPatientSummaryFactory;
import org.openvpms.web.workspace.workflow.investigation.InvestigationCRUDWindow;
import org.openvpms.web.workspace.workflow.investigation.InvestigationsQuery;
import org.openvpms.web.workspace.workflow.investigation.InvestigationsTableModel;

public class InvestigationsWorkspace
extends ResultSetCRUDWorkspace<Act> {
    private final Preferences preferences;

    public InvestigationsWorkspace(Context context, MailContext mailContext, Preferences preferences) {
        super("workflow.investigation", context);
        this.setArchetypes(Archetypes.create((String)"act.patientInvestigation", Act.class));
        this.setMailContext(mailContext);
        this.preferences = preferences;
    }

    public Component getSummary() {
        ResultSetCRUDWindow window = this.getCRUDWindow();
        if (window != null) {
            CustomerPatientSummaryFactory factory = (CustomerPatientSummaryFactory)ServiceHelper.getBean(CustomerPatientSummaryFactory.class);
            CustomerPatientSummary summary = factory.createCustomerPatientSummary(this.getContext(), this.getHelpContext(), this.preferences);
            return summary.getSummary((Act)window.getObject());
        }
        return null;
    }

    protected boolean selectFirstObjectOnQuery() {
        return false;
    }

    protected void onBrowserQuery() {
        Act selected = (Act)this.getObject();
        super.onBrowserQuery();
        List objects = this.getBrowser().getObjects();
        ResultSetCRUDWindow window = this.getCRUDWindow();
        if (selected != null && objects.contains(selected)) {
            window.setObject((IMObject)selected);
        } else {
            window.setObject(null);
        }
    }

    protected Query<Act> createQuery() {
        return new InvestigationsQuery((LayoutContext)new DefaultLayoutContext(this.getContext(), this.getHelpContext()));
    }

    protected Browser<Act> createBrowser(Query<Act> query) {
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.getContext(), this.getHelpContext());
        layoutContext.setContextSwitchListener((ContextSwitchListener)DefaultContextSwitchListener.INSTANCE);
        InvestigationsTableModel model = new InvestigationsTableModel((LayoutContext)layoutContext);
        return BrowserFactory.create(query, null, (IMTableModel)model, (LayoutContext)layoutContext);
    }

    protected boolean refreshWorkspace() {
        return true;
    }

    protected CRUDWindow<Act> createCRUDWindow() {
        QueryBrowser browser = this.getBrowser();
        return new InvestigationCRUDWindow((Archetypes<Act>)this.getArchetypes(), (Query<Act>)browser.getQuery(), (ResultSet<Act>)browser.getResultSet(), this.getContext(), this.getHelpContext());
    }

    protected void onBrowserSelected(Act object) {
        super.onBrowserSelected((IMObject)object);
        if (this.updateSummaryOnChildUpdate()) {
            this.firePropertyChange("summary", null, null);
        }
    }
}

