/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.investigation;

import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.doc.DocumentViewer;
import org.openvpms.web.component.im.doc.DocumentViewerFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.investigation.InvestigationsQuery;

class InvestigationsTableModel
extends DescriptorTableModel<Act> {
    private final PatientRules rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
    private final DocumentViewerFactory factory = (DocumentViewerFactory)ServiceHelper.getBean(DocumentViewerFactory.class);
    private int startTimeIndex;
    private int endTimeIndex;
    private int patientIndex;
    private int customerIndex;
    private int documentIndex;
    private int supplierIndex;
    private int clinicianIndex;
    private int locationIndex;
    private Party patient;
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String INVESTIGATION_TYPE = "investigationType";
    private static final String PATIENT = "patient";
    private static final String CLINICIAN = "clinician";
    private static final String LOCATION = "location";

    public InvestigationsTableModel(LayoutContext context) {
        super(InvestigationsQuery.ARCHETYPES, context);
    }

    public void postRender() {
        super.postRender();
        this.patient = null;
    }

    protected String[] getNodeNames() {
        return new String[]{START_TIME, END_TIME, INVESTIGATION_TYPE, PATIENT, "id", "status", "status2", CLINICIAN, LOCATION};
    }

    protected Object getValue(Act act, TableColumn column, int row) {
        Object result;
        int index = column.getModelIndex();
        if (index == this.startTimeIndex) {
            result = this.formatDateTime(act.getActivityStartTime());
        } else if (index == this.endTimeIndex) {
            result = this.formatDateTime(act.getActivityEndTime());
        } else if (index == this.patientIndex) {
            result = this.getPatient(act);
        } else if (index == this.customerIndex) {
            result = this.getCustomer(act);
        } else if (index == this.supplierIndex) {
            result = this.getSupplier(act);
        } else if (index == this.documentIndex) {
            DocumentViewer viewer = this.factory.create((DocumentAct)act, true, this.getLayoutContext());
            viewer.setShowNoDocument(false);
            result = viewer.getComponent();
        } else {
            result = index == this.clinicianIndex ? this.getClinician(act) : (index == this.locationIndex ? this.getLocation(act) : super.getValue((IMObject)act, column, row));
        }
        return result;
    }

    protected TableColumnModel createColumnModel(String[] shortNames, LayoutContext context) {
        DefaultTableColumnModel model = (DefaultTableColumnModel)super.createColumnModel(shortNames, context);
        this.startTimeIndex = this.getModelIndex((TableColumnModel)model, START_TIME);
        this.endTimeIndex = this.getModelIndex((TableColumnModel)model, END_TIME);
        this.patientIndex = this.getModelIndex((TableColumnModel)model, PATIENT);
        this.customerIndex = this.getNextModelIndex((TableColumnModel)model);
        TableColumn customerColumn = InvestigationsTableModel.createTableColumn((int)this.customerIndex, (String)"investigationstablemodel.customer");
        model.addColumn(customerColumn);
        model.moveColumn(model.getColumnCount() - 1, this.getColumnOffset((TableColumnModel)model, PATIENT));
        this.supplierIndex = this.getNextModelIndex((TableColumnModel)model);
        TableColumn supplierColumnn = InvestigationsTableModel.createTableColumn((int)this.supplierIndex, (String)"investigationstablemodel.supplier");
        model.addColumn(supplierColumnn);
        this.documentIndex = this.getNextModelIndex((TableColumnModel)model);
        TableColumn documentColumn = new TableColumn(this.documentIndex);
        String displayName = this.getDisplayName("act.patientInvestigation", "document");
        documentColumn.setHeaderValue((Object)displayName);
        model.addColumn(documentColumn);
        this.clinicianIndex = this.getModelIndex((TableColumnModel)model, CLINICIAN);
        this.locationIndex = this.getModelIndex((TableColumnModel)model, LOCATION);
        return model;
    }

    protected TableColumn createColumn(List<ArchetypeDescriptor> archetypes, String name, int index) {
        TableColumn column = super.createColumn(archetypes, name, index);
        if ("id".equals(name)) {
            column.setHeaderValue((Object)Messages.get((String)"investigationstablemodel.requestId"));
        }
        return column;
    }

    protected IMObjectBean initCurrent(IMObject object) {
        IMObjectBean bean = super.initCurrent(object);
        this.patient = (Party)this.getCached(bean.getTargetRef(PATIENT));
        return bean;
    }

    private Component getPatient(Act act) {
        this.getCurrent((IMObject)act);
        return this.patient != null ? this.createViewer(this.patient.getObjectReference(), this.patient.getName(), true) : null;
    }

    private Component getCustomer(Act act) {
        Reference reference;
        Component result = null;
        this.getCurrent((IMObject)act);
        if (this.patient != null && (reference = this.rules.getOwnerReference(this.patient, act.getActivityStartTime())) != null) {
            result = this.createViewer(reference, true);
        }
        return result;
    }

    private Component getSupplier(Act act) {
        IMObjectBean investigationTypeBean;
        Reference ref;
        Component result = null;
        IMObjectBean bean = this.getCurrent((IMObject)act);
        Entity investigationType = (Entity)this.getCached(bean.getTargetRef(INVESTIGATION_TYPE));
        if (investigationType != null && (ref = (investigationTypeBean = this.getBean((IMObject)investigationType)).getTargetRef("supplier")) != null) {
            result = this.createViewer(ref, true);
        }
        return result;
    }

    private Component getClinician(Act act) {
        return this.createViewer(act, CLINICIAN, false);
    }

    private Component getLocation(Act act) {
        return this.createViewer(act, LOCATION, false);
    }

    private IMObject getCached(Reference reference) {
        return reference != null ? this.getLayoutContext().getCache().get(reference) : null;
    }

    private String formatDateTime(Date date) {
        return date != null ? DateFormatter.formatDateTimeAbbrev((Date)date) : null;
    }
}

