/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.investigation;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.layout.GridLayoutData;
import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.clinician.ClinicianSelectField;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.location.LocationSelectField;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.LookupFilter;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.select.AbstractSelectorListener;
import org.openvpms.web.component.im.select.IMObjectSelector;
import org.openvpms.web.component.im.select.SelectorListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.investigation.InvestigationResultSet;

public class InvestigationsQuery
extends DateRangeActQuery<Act> {
    public static final String[] ARCHETYPES = new String[]{"act.patientInvestigation"};
    public static final String INCOMPLETE = "INCOMPLETE";
    private final LocationSelectField location;
    private final SelectField clinician;
    private final IMObjectSelector<Entity> investigationType;
    private final LookupField orderStatusSelector;
    private static final org.openvpms.component.model.lookup.Lookup INCOMPLETE_STATUS = new Lookup(new ArchetypeId("lookup.local"), "INCOMPLETE", Messages.get((String)"investigation.incomplete"));
    private static final SortConstraint[] DEFAULT_SORT = new SortConstraint[]{new NodeSortConstraint("startTime", false)};
    private static final ActStatuses STATUSES;
    private static final ActStatuses ORDER_STATUS;
    private static final String[] REVIEWED_STATUS;

    public InvestigationsQuery(LayoutContext context) {
        super(null, null, null, ARCHETYPES, STATUSES, Act.class);
        this.setDefaultSortConstraint(DEFAULT_SORT);
        this.setAuto(true);
        this.setContains(true);
        this.location = this.createLocationSelector(context.getContext());
        this.clinician = this.createClinicianSelector();
        this.investigationType = this.createInvestigationTypeSelector(context);
        this.orderStatusSelector = LookupFieldFactory.create((LookupQuery)ORDER_STATUS, (boolean)true);
        this.orderStatusSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent e) {
                InvestigationsQuery.this.onStatusChanged();
            }
        });
    }

    public void setLocation(Party location) {
        this.location.setSelectedItem((Object)location);
    }

    public Party getLocation() {
        return (Party)this.location.getSelectedItem();
    }

    public void setInvestigationType(Entity type) {
        this.investigationType.setObject((Object)type);
    }

    public void setClinician(User clinician) {
        this.clinician.setSelectedItem((Object)clinician);
    }

    public void setOrderStatus(String status) {
        this.orderStatusSelector.setSelected(status);
    }

    public Extent getHeight() {
        return this.getHeight(3);
    }

    protected Component createContainer() {
        return GridFactory.create((int)6);
    }

    protected void doLayout(Component container) {
        this.addSearchField(container);
        this.addStatusSelector(container);
        this.addOrderStatusSelector(container);
        this.addDateRange(container);
        this.addLocation(container);
        this.addClinician(container);
        this.addInvestigationType(container);
    }

    protected void addOrderStatusSelector(Component container) {
        Label label = LabelFactory.create();
        label.setText(DescriptorHelper.getDisplayName((String)"act.patientInvestigation", (String)"status2", (ArchetypeService)this.getService()));
        container.add((Component)label);
        container.add((Component)this.orderStatusSelector);
        this.getFocusGroup().add((Component)this.orderStatusSelector);
    }

    protected ResultSet<Act> createResultSet(SortConstraint[] sort) {
        String[] orderStatus;
        ArrayList<ParticipantConstraint> list = new ArrayList<ParticipantConstraint>();
        ParticipantConstraint supplier = this.getParticipantConstraint();
        if (supplier != null) {
            list.add(supplier);
        }
        QueryHelper.addParticipantConstraint(list, (String)"investigationType", (String)"participation.investigationType", (Entity)((Entity)this.investigationType.getObject()));
        QueryHelper.addParticipantConstraint(list, (String)"clinician", (String)"participation.clinician", (Entity)((Entity)this.clinician.getSelectedItem()));
        ParticipantConstraint[] participants = list.toArray(new ParticipantConstraint[0]);
        Party location = (Party)this.location.getSelectedItem();
        String[] statuses = this.getStatuses();
        boolean exclude = false;
        org.openvpms.component.model.lookup.Lookup selected = this.orderStatusSelector.getSelected();
        if (selected == INCOMPLETE_STATUS) {
            orderStatus = REVIEWED_STATUS;
            exclude = true;
            if (statuses.length == 0) {
                statuses = new String[]{"IN_PROGRESS", "POSTED"};
            }
        } else if (selected != null) {
            if ("CONFIRM".equals(selected.getCode())) {
                orderStatus = new String[]{"CONFIRM", "CONFIRM_DEFERRED"};
                if (statuses.length == 0) {
                    statuses = new String[]{"IN_PROGRESS", "POSTED"};
                }
            } else {
                orderStatus = new String[]{selected.getCode()};
            }
        } else {
            orderStatus = new String[]{};
        }
        return new InvestigationResultSet(this.getArchetypeConstraint(), this.getValue(), participants, location, this.location.getLocations(), this.getFrom(), this.getTo(), statuses, orderStatus, exclude, this.getMaxResults(), sort);
    }

    protected String[] getStatuses() {
        Object[] statuses = super.getStatuses();
        if (ArrayUtils.contains((Object[])statuses, (Object)"CONFIRM")) {
            statuses = (String[])ArrayUtils.add((Object[])statuses, (Object)"CONFIRM_DEFERRED");
        }
        return statuses;
    }

    private void addInvestigationType(Component container) {
        Label label = LabelFactory.create();
        label.setText(this.investigationType.getType());
        container.add((Component)label);
        Component component = this.investigationType.getComponent();
        GridLayoutData layoutData = new GridLayoutData();
        layoutData.setColumnSpan(3);
        component.setLayoutData((LayoutData)layoutData);
        container.add(component);
        this.investigationType.getSelect().setFocusTraversalParticipant(false);
        this.getFocusGroup().add((Component)this.investigationType.getTextField());
    }

    private IMObjectSelector<Entity> createInvestigationTypeSelector(LayoutContext context) {
        IMObjectSelector selector = new IMObjectSelector(DescriptorHelper.getDisplayName((String)"entity.investigationType", (ArchetypeService)this.getService()), context, new String[]{"entity.investigationType"});
        AbstractSelectorListener<Entity> listener = new AbstractSelectorListener<Entity>(){

            public void selected(Entity object) {
                InvestigationsQuery.this.onQuery();
            }
        };
        selector.setListener((SelectorListener)listener);
        return selector;
    }

    private void addClinician(Component container) {
        Label label = LabelFactory.create();
        label.setText(Messages.get((String)"label.clinician"));
        container.add((Component)label);
        container.add((Component)this.clinician);
        this.getFocusGroup().add((Component)this.clinician);
    }

    private void addLocation(Component container) {
        Label label = LabelFactory.create();
        label.setText(DescriptorHelper.getDisplayName((String)"act.patientInvestigation", (String)"location", (ArchetypeService)this.getService()));
        container.add((Component)label);
        container.add((Component)this.location);
        this.getFocusGroup().add((Component)this.location);
    }

    private LocationSelectField createLocationSelector(Context context) {
        LocationSelectField result = new LocationSelectField(context.getUser(), context.getPractice(), true);
        result.setSelectedItem((Object)context.getLocation());
        result.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                InvestigationsQuery.this.onQuery();
            }
        });
        return result;
    }

    private SelectField createClinicianSelector() {
        ClinicianSelectField result = new ClinicianSelectField();
        result.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                InvestigationsQuery.this.onQuery();
            }
        });
        return result;
    }

    static {
        ORDER_STATUS = new ActStatuses((LookupQuery)new OrderStatusQuery(), null);
        REVIEWED_STATUS = new String[]{"REVIEWED"};
        STATUSES = new ActStatuses("act.patientInvestigation");
        STATUSES.setDefault((String)null);
    }

    private static class OrderStatusQuery
    extends LookupFilter {
        public OrderStatusQuery() {
            super((LookupQuery)new NodeLookupQuery("act.patientInvestigation", "status2"), false, new String[]{"CONFIRM_DEFERRED"});
        }

        public org.openvpms.component.model.lookup.Lookup getDefault() {
            return INCOMPLETE_STATUS;
        }

        public List<org.openvpms.component.model.lookup.Lookup> getLookups() {
            List lookups = super.getLookups();
            lookups.add(0, INCOMPLETE_STATUS);
            return lookups;
        }
    }
}

