/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.investigation;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NotConstraint;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;

public class InvestigationResultSet
extends ActResultSet<Act> {
    private final Party location;
    private final List<Party> locations;
    private final String[] resultStatuses;
    private final boolean exclude;

    public InvestigationResultSet(ShortNameConstraint archetypes, String value, ParticipantConstraint[] participants, Party location, List<Party> locations, Date from, Date to, String[] statuses, String[] resultStatuses, boolean exclude, int pageSize, SortConstraint[] sort) {
        super(archetypes, value, participants, from, to, statuses, false, null, pageSize, sort);
        this.location = location;
        this.locations = locations;
        this.resultStatuses = resultStatuses;
        this.exclude = exclude;
    }

    protected ArchetypeQuery createQuery() {
        IConstraint resultStatus;
        ArchetypeQuery query = super.createQuery();
        String value = this.getValue();
        if (!StringUtils.isEmpty((CharSequence)value) && this.getId(value) == null) {
            query.add((IConstraint)Constraints.join((String)"patient").add((IConstraint)Constraints.join((String)"entity").add((IConstraint)Constraints.eq((String)"name", (Object)value))));
        }
        if (this.location != null || !this.locations.isEmpty()) {
            query.add((IConstraint)Constraints.leftJoin((String)"location", (String)"location"));
            OrConstraint or = new OrConstraint();
            if (this.location != null) {
                or.add((IConstraint)Constraints.eq((String)"location.entity", (Object)this.location));
            } else {
                for (Party l : this.locations) {
                    or.add((IConstraint)Constraints.eq((String)"location.entity", (Reference)l.getObjectReference()));
                }
            }
            or.add((IConstraint)this.getNoLocation());
            query.add((IConstraint)or);
        }
        if ((resultStatus = this.createStatusConstraint("status2", this.resultStatuses, this.exclude)) != null) {
            query.add(resultStatus);
        }
        return query;
    }

    private NotConstraint getNoLocation() {
        return Constraints.notExists((ArchetypeQuery)Constraints.subQuery((String)"act.patientInvestigation", (String)"i2").add((IConstraint)Constraints.join((String)"location").add((IConstraint)Constraints.join((String)"entity").add((IConstraint)Constraints.idEq((String)"act", (String)"i2")))));
    }
}

