/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.investigation;

import java.util.Set;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.SoftRefIMObjectCache;
import org.openvpms.web.workspace.customer.charge.OrderPlacer;
import org.openvpms.web.workspace.customer.charge.OrderServices;

public class InvestigationCanceller {
    private final OrderPlacer placer;
    private final IArchetypeService service;
    private final IMObjectBean bean;

    public InvestigationCanceller(Act investigation, User user, Party practice, OrderServices services, PatientRules rules, IArchetypeService service) {
        this.bean = service.getBean((IMObject)investigation);
        SoftRefIMObjectCache cache = new SoftRefIMObjectCache((ArchetypeService)service);
        Entity laboratory = (Entity)cache.get(this.bean.getTargetRef("laboratory"));
        if (laboratory != null) {
            Party patient = (Party)cache.get(this.bean.getTargetRef("patient"));
            Party location = (Party)cache.get(this.bean.getTargetRef("location"));
            if (patient == null) {
                throw new IllegalStateException("Cannot determine patient from investigation");
            }
            if (location == null) {
                throw new IllegalStateException("Cannot determine location from investigation");
            }
            Party customer = rules.getOwner(patient, investigation.getActivityStartTime(), false);
            if (customer == null) {
                throw new IllegalStateException("Cannot determine customer from investigation");
            }
            this.placer = new OrderPlacer(customer, location, user, practice, (IMObjectCache)cache, services, (ArchetypeService)service);
            this.placer.initialise(investigation);
        } else {
            this.placer = null;
        }
        this.service = service;
    }

    public boolean isCharged() {
        return this.bean.getSourceRef("invoiceItems") != null;
    }

    public boolean cancel() {
        boolean result = false;
        if (this.placer != null) {
            Set<Act> updated = this.placer.cancel();
            if (!updated.isEmpty()) {
                this.service.save(updated);
                result = true;
            }
        } else if (!"CANCELLED".equals(this.bean.getString("status"))) {
            this.bean.setValue("status", (Object)"CANCELLED");
            this.bean.save();
        }
        return result;
    }
}

