/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.CageType;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.workspace.workflow.checkout.Visit;

class Visits
implements Iterable<Visit> {
    private final Party customer;
    private final AppointmentRules appointmentRules;
    private final PatientRules patientRules;
    private final IArchetypeService service;
    private List<Visit> visits = new ArrayList<Visit>();

    public Visits(Party customer, AppointmentRules appointmentRules, PatientRules patientRules, IArchetypeService service) {
        this.customer = customer;
        this.appointmentRules = appointmentRules;
        this.patientRules = patientRules;
        this.service = service;
    }

    public Visit create(Act event, Act appointment) {
        return new Visit(event, appointment, this.appointmentRules, this.patientRules, this.service);
    }

    public void add(Act event, Act appointment) {
        this.visits.add(this.create(event, appointment));
    }

    public void add(Visit visit) {
        this.visits.add(visit);
    }

    @Override
    public Iterator<Visit> iterator() {
        return this.visits.iterator();
    }

    public void addAll(List<Visit> visits) {
        this.visits.addAll(visits);
    }

    public Set<Reference> getPatients() {
        LinkedHashSet<Reference> patients = new LinkedHashSet<Reference>();
        for (Visit visit : this.visits) {
            IMObjectBean bean = this.service.getBean((IMObject)visit.getEvent());
            Reference patient = bean.getTargetRef("patient");
            if (patient == null) continue;
            patients.add(patient);
        }
        return patients;
    }

    public boolean isEmpty() {
        return this.visits.isEmpty();
    }

    public void reload() {
        ArrayList<Visit> reloaded = new ArrayList<Visit>();
        for (Visit visit : this.visits) {
            boolean isFirstPet = visit.isFirstPet();
            Act event = visit.getEvent();
            Act appointment = (Act)IMObjectHelper.reload((IMObject)visit.getAppointment());
            visit = this.create(event, appointment);
            visit.setFirstPet(isFirstPet);
            reloaded.add(visit);
        }
        this.visits = reloaded;
    }

    public void rate(List<Visit> visits, Date endTime) {
        HashMap<VisitKey, List> map = new HashMap<VisitKey, List>();
        for (Visit visit : visits) {
            VisitKey key = VisitKey.create(visit, endTime);
            if (key == null) continue;
            List list = map.computeIfAbsent(key, k -> new ArrayList());
            list.add(visit);
        }
        for (Map.Entry entry : map.entrySet()) {
            List incomplete = (List)entry.getValue();
            if (this.firstPetRateCharged((VisitKey)entry.getKey(), incomplete)) {
                for (Visit visit : incomplete) {
                    visit.setFirstPet(false);
                }
                continue;
            }
            this.sortOnWeight(incomplete);
            boolean first = true;
            for (Visit visit : incomplete) {
                visit.setFirstPet(first);
                first = false;
            }
        }
    }

    public void save() {
        for (Visit visit : this.visits) {
            visit.save();
        }
    }

    private void sortOnWeight(List<Visit> visits) {
        visits.sort((o1, o2) -> {
            BigDecimal weight2;
            BigDecimal weight1 = o1.getWeight().toKilograms();
            int result = weight1.compareTo(weight2 = o2.getWeight().toKilograms());
            result = result == 0 ? Long.compare(o1.getPatient().getId(), o2.getPatient().getId()) : -result;
            return result;
        });
    }

    private boolean firstPetRateCharged(VisitKey key, List<Visit> exclude) {
        boolean result = false;
        ArchetypeQuery query = new ArchetypeQuery("act.patientClinicalEvent");
        query.add((IConstraint)Constraints.join((String)"patient").add((IConstraint)Constraints.join((String)"entity").add((IConstraint)Constraints.join((String)"customers").add((IConstraint)Constraints.eq((String)"source", (Object)this.customer)))));
        JoinConstraint appointmentJoin = Constraints.join((String)"source");
        appointmentJoin.add((IConstraint)Constraints.ne((String)"status", (Object)"CANCELLED"));
        appointmentJoin.add((IConstraint)Constraints.join((String)"schedule").add((IConstraint)Constraints.eq((String)"entity", (Reference)key.schedule)));
        query.add((IConstraint)Constraints.join((String)"appointment").add((IConstraint)appointmentJoin));
        query.add((IConstraint)Constraints.gte((String)"startTime", (Object)key.start));
        query.add((IConstraint)Constraints.lt((String)"startTime", (Object)DateRules.getNextDate((Date)key.start)));
        query.add((IConstraint)Constraints.gte((String)"endTime", (Object)key.end));
        query.add((IConstraint)Constraints.lte((String)"endTime", (Object)DateRules.getNextDate((Date)key.end)));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Visit visit : exclude) {
            ids.add(visit.getEvent().getId());
        }
        query.add((IConstraint)Constraints.not((IConstraint)Constraints.in((String)"id", (Object[])ids.toArray())));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            IMObjectBean appointmentBean;
            Act event = (Act)iterator.next();
            IMObjectBean bean = this.service.getBean((IMObject)event);
            Act appointment = (Act)bean.getSource("appointment", Act.class);
            if (appointment == null || !(appointmentBean = this.service.getBean((IMObject)appointment)).getBoolean("boardingCharged") || !appointmentBean.getBoolean("firstPetRate")) continue;
            result = true;
            break;
        }
        return result;
    }

    private static class VisitKey {
        private final Reference schedule;
        private final Date start;
        private final Date end;

        VisitKey(Reference schedule, Date startTime, Date endTime) {
            this.schedule = schedule;
            this.start = DateRules.getDate((Date)startTime);
            Date date = DateRules.getDate((Date)endTime);
            if (DateRules.compareTo((Date)date, (Date)endTime) == 0) {
                date = DateRules.getPreviousDate((Date)date);
            }
            this.end = date;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof VisitKey) {
                VisitKey other = (VisitKey)obj;
                return this.schedule.equals((Object)other.schedule) && this.start.equals(other.start) && this.end.equals(other.end);
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.schedule).append((Object)this.start).append((Object)this.end).toHashCode();
        }

        public static VisitKey create(Visit visit, Date endTime) {
            CageType cageType;
            Reference schedule = visit.getScheduleRef();
            if (visit.getEndTime() != null) {
                endTime = visit.getEndTime();
            }
            if (schedule != null && endTime != null && visit.getCageType() != null && (cageType = visit.getCageType()).hasSecondPetProducts()) {
                return new VisitKey(schedule, visit.getStartTime(), endTime);
            }
            return null;
        }
    }
}

