/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.act.PrintedFlagUpdater;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.print.BatchPrintDialog;
import org.openvpms.web.component.print.BatchPrinter;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.checkout.PrintDocumentsMailer;

class PrintDocumentsTask
extends AbstractTask {
    private final Set<Reference> patients;
    private final Date startTime;
    private final HelpContext help;
    private BatchPrintDialog<Act> dialog;
    private static final String[] CHARGES = new String[]{"act.customerAccountCharges*"};
    private static final String[] DOCUMENTS = new String[]{"act.patientDocumentLetter", "act.patientDocumentForm"};
    private static final String MAIL_ID = "mail";

    public PrintDocumentsTask(Set<Reference> patients, Date startTime, HelpContext help) {
        this.patients = patients;
        this.startTime = startTime;
        this.help = help;
    }

    public void start(final TaskContext context) {
        LinkedHashMap<Act, Boolean> unprinted = new LinkedHashMap<Act, Boolean>();
        unprinted.putAll(this.getCustomerActs(context));
        unprinted.putAll(this.getPatientActs());
        if (unprinted.isEmpty()) {
            this.notifyCompleted();
        } else {
            String title = Messages.get((String)"workflow.print.title");
            String[] buttons = this.isRequired() ? PopupDialog.OK_CANCEL : PopupDialog.OK_SKIP_CANCEL;
            this.dialog = new BatchPrintDialog(title, null, buttons, unprinted, this.help);
            this.dialog.getButtons().add(MAIL_ID, () -> this.onMail(context));
            this.dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    try {
                        String action = PrintDocumentsTask.this.dialog.getAction();
                        if ("ok".equals(action)) {
                            PrintDocumentsTask.this.print(PrintDocumentsTask.this.dialog.getSelected(), context);
                        } else if (PrintDocumentsTask.MAIL_ID.equals(action)) {
                            PrintDocumentsTask.this.notifyCompleted();
                        } else if ("skip".equals(action)) {
                            PrintDocumentsTask.this.notifySkipped();
                        } else {
                            PrintDocumentsTask.this.notifyCancelled();
                        }
                    }
                    finally {
                        PrintDocumentsTask.this.dialog = null;
                    }
                }
            });
            this.dialog.show();
        }
    }

    public BatchPrintDialog<Act> getPrintDialog() {
        return this.dialog;
    }

    private void print(List<Act> objects, TaskContext context) {
        Printer printer = new Printer(objects, context);
        printer.print();
    }

    private Map<Act, Boolean> getCustomerActs(TaskContext context) {
        Party customer = context.getCustomer();
        return this.getUnprintedActs(CHARGES, customer.getObjectReference(), "customer");
    }

    private Map<Act, Boolean> getPatientActs() {
        LinkedHashMap<Act, Boolean> result = new LinkedHashMap<Act, Boolean>();
        for (Reference patient : this.patients) {
            result.putAll(this.getUnprintedActs(DOCUMENTS, patient, "patient"));
        }
        return result;
    }

    private Map<Act, Boolean> getUnprintedActs(String[] archetypes, Reference party, String node) {
        LinkedHashMap<Act, Boolean> result = new LinkedHashMap<Act, Boolean>();
        ArchetypeQuery query = new ArchetypeQuery(archetypes, false, true);
        query.setFirstResult(0);
        query.setMaxResults(-1);
        query.add((IConstraint)Constraints.join((String)node).add((IConstraint)Constraints.eq((String)"entity", (Reference)party)));
        query.add((IConstraint)Constraints.gte((String)"startTime", (Object)this.startTime));
        query.add((IConstraint)Constraints.eq((String)"printed", (Object)false));
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        for (IMObject object : service.get((IArchetypeQuery)query).getResults()) {
            DocumentTemplate.PrintMode mode = this.getPrintMode((Act)object);
            boolean select = mode == null || mode == DocumentTemplate.PrintMode.CHECK_OUT;
            result.put((Act)object, select);
        }
        return result;
    }

    private void onMail(TaskContext context) {
        List list = this.dialog.getSelected();
        if (!list.isEmpty()) {
            PrintDocumentsMailer mailer = new PrintDocumentsMailer(context);
            mailer.mail(list, () -> {
                this.updatePrinted(list);
                if (this.dialog.getAvailable().size() == list.size()) {
                    this.dialog.close(MAIL_ID);
                }
            });
        }
    }

    private void updatePrinted(List<Act> list) {
        PrintedFlagUpdater updater = new PrintedFlagUpdater();
        for (Act object : list) {
            updater.setPrinted(object);
        }
    }

    private DocumentTemplate.PrintMode getPrintMode(Act act) {
        Entity entity;
        DocumentTemplate.PrintMode result = null;
        IMObjectBean bean = this.getBean((IMObject)act);
        if (bean.hasNode("documentTemplate") && (entity = (Entity)bean.getTarget("documentTemplate", Entity.class)) != null) {
            DocumentTemplate template = new DocumentTemplate(entity, (ArchetypeService)ServiceHelper.getArchetypeService());
            result = template.getPrintMode();
        }
        return result;
    }

    class Printer
    extends BatchPrinter<Act> {
        public Printer(List<Act> objects, TaskContext context) {
            super(objects, (Context)context, context.getHelpContext());
        }

        public void cancelled() {
            PrintDocumentsTask.this.start(this.getContext());
        }

        public void failed(Throwable cause) {
            ErrorHelper.show((Throwable)cause, () -> PrintDocumentsTask.this.start(this.getContext()));
        }

        protected void completed() {
            PrintDocumentsTask.this.notifyCompleted();
        }

        protected InteractiveIMPrinter<Act> createInteractivePrinter(IMPrinter<Act> printer) {
            InteractiveIMPrinter result = super.createInteractivePrinter(printer);
            result.setInteractive(false);
            return result;
        }

        protected TaskContext getContext() {
            return (TaskContext)super.getContext();
        }
    }
}

