/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.util.Iterator;
import nextapp.echo2.app.Component;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.AlertManager;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.im.view.IMObjectViewerDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.order.PendingOrderQuery;
import org.openvpms.web.workspace.workflow.checkout.Visit;
import org.openvpms.web.workspace.workflow.checkout.Visits;

class InvoiceViewerDialog
extends IMObjectViewerDialog {
    private final AlertManager alerts;
    static final String NEW_ID = "button.new";
    private static final String[] BUTTONS = new String[]{"button.new", "ok", "cancel"};

    InvoiceViewerDialog(FinancialAct invoice, Visits visits, Context context, HelpContext help) {
        super(null, BUTTONS, context, null, help);
        this.setViewer(new IMObjectViewer((IMObject)invoice, null, (LayoutContext)new DefaultLayoutContext(context, help)));
        this.alerts = new AlertManager((Component)this.getContentPane(), 3);
        Party customer = context.getCustomer();
        PendingOrderQuery query = new PendingOrderQuery(customer);
        Iterator iterator = query.iterator();
        this.alerts.show(Messages.get((String)"workflow.checkout.invoice.posted"));
        if (iterator.hasNext()) {
            this.alerts.show(Messages.format((String)"customer.order.pending", (Object[])new Object[]{customer.getName()}));
        }
        for (Visit visit : visits) {
            if (!visit.needsCharge()) continue;
            this.alerts.show(Messages.get((String)"workflow.checkout.invoice.boarding"));
            break;
        }
    }

    protected void onClose() {
        this.alerts.clear();
        super.onClose();
    }
}

