/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.IMTable;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.table.DefaultTableHeaderRenderer;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.WorkflowException;
import org.openvpms.web.workspace.workflow.checkout.Visit;
import org.openvpms.web.workspace.workflow.checkout.Visits;
import org.openvpms.web.workspace.workflow.i18n.WorkflowMessages;

class GetBoardingAppointmentsTask
extends AbstractTask {
    private final Act appointment;
    private final Visits visits;
    private final AppointmentRules rules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);

    public GetBoardingAppointmentsTask(Act appointment, Visits visits) {
        this.appointment = appointment;
        this.visits = visits;
    }

    public void start(final TaskContext context) {
        Act event = this.rules.getEvent(this.appointment);
        if (event == null) {
            Party patient = context.getPatient();
            if (patient == null) {
                throw new WorkflowException(WorkflowMessages.contextHasNoPatient());
            }
            InformationDialog.show((String)Messages.format((String)"workflow.checkin.visit.novisit", (Object[])new Object[]{patient.getName(), this.appointment.getActivityStartTime()}));
            this.notifyCancelled();
        } else {
            List<Visit> selections = this.getVisits(context);
            selections.add(0, this.visits.create(event, this.appointment));
            DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)context, context.getHelpContext());
            final SelectionDialog dialog = new SelectionDialog(this.visits, selections, this.appointment, (LayoutContext)layoutContext);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    GetBoardingAppointmentsTask.this.onSelected(dialog.getSelected(), context);
                }

                public void onAction(String action) {
                    GetBoardingAppointmentsTask.this.notifyCancelled();
                }
            });
            dialog.show();
        }
    }

    private void onSelected(List<Visit> visits, TaskContext context) {
        this.visits.addAll(visits);
        if (visits.size() == 1) {
            Visit visit = visits.get(0);
            context.addObject((IMObject)visit.getEvent());
            context.addObject((IMObject)visit.getAppointment());
            context.addObject((IMObject)visit.getPatient());
        }
        this.notifyCompleted();
    }

    private List<Visit> getVisits(TaskContext context) {
        ArrayList<Visit> result = new ArrayList<Visit>();
        Party customer = context.getCustomer();
        if (customer == null) {
            throw new WorkflowException(WorkflowMessages.contextHasNoCustomer());
        }
        Party location = context.getLocation();
        if (location == null) {
            throw new WorkflowException(WorkflowMessages.contextHasNoLocation());
        }
        Iterable iterable = this.rules.getActiveCustomerAppointments(customer, location, this.appointment);
        for (Act act : iterable) {
            Visit e;
            Act event = this.rules.getEvent(act);
            if (event == null || (e = this.visits.create(event, act)).getCageType() == null) continue;
            result.add(e);
        }
        return result;
    }

    private static class VisitTableModel
    extends AbstractIMTableModel<Visit> {
        private final Visits visits;
        private List<CheckBox> selected = new ArrayList<CheckBox>();
        private final Act required;
        private final LayoutContext context;
        private static final int SELECTED_INDEX = 0;
        private static final int SCHEDULE_INDEX = 1;
        private static final int PATIENT_INDEX = 2;
        private static final int APPOINTMENT_INDEX = 3;
        private static final int EVENT_INDEX = 4;
        private static final int REASON_INDEX = 5;
        private static final int DAYS_INDEX = 6;
        private static final int RATE_INDEX = 7;
        private static final int LATE_CHECKOUT_INDEX = 8;
        private static final int CHARGED_INDEX = 9;

        public VisitTableModel(Visits visits, List<Visit> selections, Act required, LayoutContext context) {
            this.visits = visits;
            this.required = required;
            this.context = new DefaultLayoutContext(context);
            this.context.setComponentFactory((IMObjectComponentFactory)new TableComponentFactory(context));
            this.setObjects(selections);
            this.setTableColumnModel(this.createTableColumnModel());
            this.rate();
        }

        public List<Visit> getSelected() {
            ArrayList<Visit> events = new ArrayList<Visit>();
            for (int i = 0; i < this.selected.size(); ++i) {
                CheckBox check = this.selected.get(i);
                if (!check.isSelected()) continue;
                events.add((Visit)this.getObject(i));
            }
            return events;
        }

        public void setObjects(List<Visit> objects) {
            super.setObjects(objects);
            this.selected = new ArrayList<CheckBox>();
            for (Visit event : objects) {
                CheckBox box = CheckBoxFactory.create((boolean)false);
                if (this.required != null && Objects.equals(this.required, event.getAppointment())) {
                    box.setEnabled(false);
                    box.setSelected(true);
                }
                this.selected.add(box);
                box.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                    public void onAction(ActionEvent event) {
                        this.rate();
                    }
                });
            }
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return null;
        }

        protected Object getValue(Visit object, TableColumn column, int row) {
            Object result = null;
            if (column instanceof DescriptorTableColumn) {
                result = ((DescriptorTableColumn)column).getComponent((IMObject)object.getAppointment(), this.context);
            } else {
                switch (column.getModelIndex()) {
                    case 0: {
                        result = this.selected.get(row);
                        break;
                    }
                    case 3: {
                        result = this.getAppointment(object);
                        break;
                    }
                    case 4: {
                        result = this.getEvent(object);
                        break;
                    }
                    case 6: {
                        result = this.getDays(object);
                        break;
                    }
                    case 7: {
                        result = this.getRate(object);
                        break;
                    }
                    case 8: {
                        result = this.getLateCheckout(object);
                        break;
                    }
                    case 9: {
                        result = this.getCharged(object);
                    }
                }
            }
            return result;
        }

        protected TableColumnModel createTableColumnModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            ArchetypeDescriptor descriptor = ServiceHelper.getArchetypeService().getArchetypeDescriptor("act.customerAppointment");
            model.addColumn(new TableColumn(0));
            model.addColumn((TableColumn)new DescriptorTableColumn(1, "schedule", (org.openvpms.component.model.archetype.ArchetypeDescriptor)descriptor));
            model.addColumn((TableColumn)new DescriptorTableColumn(2, "patient", (org.openvpms.component.model.archetype.ArchetypeDescriptor)descriptor));
            model.addColumn((TableColumn)new DescriptorTableColumn(5, "reason", (org.openvpms.component.model.archetype.ArchetypeDescriptor)descriptor));
            model.addColumn(VisitTableModel.createTableColumn((int)3, (String)"workflow.checkout.appointments.appointment"));
            model.addColumn(VisitTableModel.createTableColumn((int)4, (String)"workflow.checkout.appointments.event"));
            model.addColumn(VisitTableModel.createTableColumn((int)6, (String)"workflow.checkout.appointments.days"));
            model.addColumn(VisitTableModel.createTableColumn((int)7, (String)"workflow.checkout.appointments.rate"));
            model.addColumn(VisitTableModel.createTableColumn((int)8, (String)"workflow.checkout.appointments.latecheckout"));
            model.addColumn(VisitTableModel.createTableColumn((int)9, (String)"workflow.checkout.appointments.charged"));
            return model;
        }

        private void rate() {
            for (Visit visit : this.getObjects()) {
                visit.setFirstPet(true);
            }
            this.visits.rate(this.getSelected(), new Date());
            this.fireTableDataChanged();
        }

        private Object getAppointment(Visit visit) {
            Act act = visit.getAppointment();
            Date startTime = act.getActivityStartTime();
            String from = DateFormatter.formatDateTimeAbbrev((Date)startTime);
            String to = DateFormatter.formatDateTimeAbbrev((Date)act.getActivityEndTime(), (Date)startTime);
            return Messages.format((String)"workflow.checkout.appointments.daterange", (Object[])new Object[]{from, to});
        }

        private Object getEvent(Visit visit) {
            Date startTime = visit.getStartTime();
            Date endTime = visit.getEndTime();
            String from = DateFormatter.formatDateTimeAbbrev((Date)startTime);
            String to = endTime != null ? DateFormatter.formatDateTimeAbbrev((Date)endTime, (Date)startTime) : Messages.get((String)"workflow.checkout.appointments.now");
            return Messages.format((String)"workflow.checkout.appointments.daterange", (Object[])new Object[]{from, to});
        }

        private Object getDays(Visit visit) {
            return TableHelper.rightAlign((String)Integer.toString(visit.getDays()));
        }

        private Object getRate(Visit visit) {
            String key = visit.isFirstPet() ? "workflow.checkout.appointments.first" : "workflow.checkout.appointments.second";
            return Messages.get((String)key);
        }

        private Object getLateCheckout(Visit visit) {
            return this.getCheckBox(visit.isLateCheckout());
        }

        private Object getCharged(Visit visit) {
            return this.getCheckBox(visit.isCharged());
        }
    }

    private static class SelectionDialog
    extends PopupDialog {
        private final IMTable<Visit> table;

        public SelectionDialog(Visits visits, List<Visit> selections, Act required, LayoutContext context) {
            super(Messages.get((String)"workflow.checkout.appointments.title"), "MediumDialog", OK_CANCEL, context.getHelpContext());
            this.setModal(true);
            VisitTableModel model = new VisitTableModel(visits, selections, required, context);
            this.table = new IMTable((IMTableModel)model);
            this.table.setDefaultHeaderRenderer(DefaultTableHeaderRenderer.DEFAULT);
            Column column = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"workflow.checkout.appointments.message"), this.table});
            this.getLayout().add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{column}));
        }

        public List<Visit> getSelected() {
            VisitTableModel model = (VisitTableModel)this.table.getModel();
            return model.getSelected();
        }
    }
}

