/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.math.BigDecimal;
import java.util.Date;
import org.openvpms.archetype.rules.workflow.CageType;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.workspace.customer.charge.AbstractInvoicer;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.workflow.checkout.Visit;
import org.openvpms.web.workspace.workflow.checkout.Visits;

class BoardingInvoicer
extends AbstractInvoicer {
    BoardingInvoicer() {
    }

    public void invoice(Visits visits, CustomerChargeActEditor editor) {
        this.invoice(visits, editor, new Date());
    }

    public void invoice(Visits visits, CustomerChargeActEditor editor, Date endTime) {
        for (Visit visit : visits) {
            if (visit.isCharged()) continue;
            CageType cageType = visit.getCageType();
            Date visitEndTime = visit.getEndTime(endTime);
            if (cageType == null) continue;
            this.chargeBoarding(visit, visitEndTime, editor);
            if (cageType.isLateCheckout(visitEndTime)) {
                this.chargeLateCheckout(visit, editor);
            }
            visit.setCharged(true);
        }
    }

    private void chargeBoarding(Visit visit, Date endTime, CustomerChargeActEditor editor) {
        Product product = visit.getProduct(endTime);
        if (product != null) {
            int days = visit.getDays(endTime);
            BigDecimal quantity = BigDecimal.valueOf(days);
            this.addItem(visit.getPatient(), product, quantity, editor);
        }
    }

    private void chargeLateCheckout(Visit visit, CustomerChargeActEditor editor) {
        CageType cageType = visit.getCageType();
        Product product = cageType.getLateCheckoutProduct();
        if (product != null) {
            this.addItem(visit.getPatient(), product, BigDecimal.ONE, editor);
        }
    }

    private void addItem(Party patient, Product product, BigDecimal quantity, CustomerChargeActEditor editor) {
        CustomerChargeActItemEditor itemEditor = this.getItemEditor(editor);
        itemEditor.setPatient(patient);
        if (TypeHelper.isA((IMObject)product, (String)"product.template")) {
            editor.getItems().expandTemplate(itemEditor, product, quantity);
        } else {
            itemEditor.setProduct(product);
            itemEditor.setQuantity(quantity);
        }
    }
}

