/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import nextapp.echo2.app.Component;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.ExistsConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.doc.AbstractDocumentTemplateQuery;
import org.openvpms.web.component.im.doc.DocumentTemplateQuery;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.system.ServiceHelper;

class ScheduleDocumentTemplateQuery
extends DocumentTemplateQuery {
    private final Entity schedule;
    private final Entity workList;

    public ScheduleDocumentTemplateQuery(Entity schedule, Entity workList) {
        if (schedule != null && ScheduleDocumentTemplateQuery.useAllTemplates(schedule) || workList != null && ScheduleDocumentTemplateQuery.useAllTemplates(workList)) {
            this.schedule = null;
            this.workList = null;
        } else {
            this.schedule = schedule;
            this.workList = workList;
        }
        this.setTemplateTypes(new String[]{"act.patientDocumentForm", "act.patientDocumentLetter"});
    }

    public boolean isAuto() {
        return true;
    }

    public Entity getSchedule() {
        return this.schedule;
    }

    public Entity getWorkList() {
        return this.workList;
    }

    public static boolean useAllTemplates(Entity schedule) {
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)schedule);
        if (bean.getValue("useAllTemplates") != null) {
            return bean.getBoolean("useAllTemplates");
        }
        return bean.getValues("templates").isEmpty();
    }

    public static boolean hasTemplates(Entity schedule) {
        boolean result = false;
        if (schedule != null) {
            if (ScheduleDocumentTemplateQuery.useAllTemplates(schedule)) {
                result = true;
            } else {
                ArchetypeQuery query = new ArchetypeQuery(schedule.getObjectReference());
                query.add((IConstraint)new NodeSelectConstraint("id"));
                query.add((IConstraint)Constraints.join((String)"templates").add((IConstraint)Constraints.join((String)"target").add((IConstraint)Constraints.eq((String)"active", (Object)true))));
                query.setMaxResults(1);
                ObjectSetQueryIterator iterator = new ObjectSetQueryIterator((IArchetypeQuery)query);
                result = iterator.hasNext();
            }
        }
        return result;
    }

    protected void doLayout(Component container) {
        this.addShortNameSelector(container);
        this.addSearchField(container);
        FocusHelper.setFocus((Component)this.getSearchField());
    }

    protected ResultSet<Entity> createResultSet(ShortNameConstraint archetypes, String[] types, SortConstraint[] sort) {
        return new AbstractDocumentTemplateQuery.TemplateResultSet(archetypes, this.getValue(), sort, this.getMaxResults(), types, this.isDistinct()){

            protected ArchetypeQuery createQuery() {
                ExistsConstraint worklistExists;
                this.getArchetypes().setAlias("t");
                ArchetypeQuery query = super.createQuery();
                ExistsConstraint scheduleExists = ScheduleDocumentTemplateQuery.this.schedule != null ? this.createExists(ScheduleDocumentTemplateQuery.this.schedule, "s") : null;
                ExistsConstraint existsConstraint = worklistExists = ScheduleDocumentTemplateQuery.this.workList != null ? this.createExists(ScheduleDocumentTemplateQuery.this.workList, "w") : null;
                if (scheduleExists != null && worklistExists != null) {
                    query.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{scheduleExists, worklistExists}));
                } else if (scheduleExists != null) {
                    query.add((IConstraint)scheduleExists);
                } else if (worklistExists != null) {
                    query.add((IConstraint)worklistExists);
                }
                return query;
            }

            private ExistsConstraint createExists(Entity entity, String alias) {
                String relAlias = alias + "r";
                return Constraints.exists((ArchetypeQuery)Constraints.subQuery((IMObject)entity, (String)alias).add((IConstraint)Constraints.join((String)"templates", (String)relAlias).add((IConstraint)Constraints.idEq((String)"t", (String)(relAlias + ".target")))));
            }
        };
    }
}

