/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.util.Date;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.TaskRules;
import org.openvpms.component.math.Weight;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.patient.PatientContextFactory;
import org.openvpms.smartflow.client.FlowSheetException;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.client.HospitalizationService;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.InformationTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.Tasks;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.visit.FlowSheetEditDialog;
import org.openvpms.web.workspace.workflow.checkin.PatientWeightTask;

public class NewFlowSheetTask
extends Tasks {
    private final Act act;
    private final Party customer;
    private final Party patient;
    private final User clinician;
    private final Party location;
    private final FlowSheetServiceFactory factory;
    private final boolean ignoreExisting;
    private final MedicalRecordRules rules;
    private final PatientContextFactory contextFactory;
    private PatientContext patientContext;
    private Act visit;
    private HospitalizationService client;

    public NewFlowSheetTask(Act act, Party location, FlowSheetServiceFactory factory, HelpContext help) {
        this(act, null, false, location, factory, help);
    }

    public NewFlowSheetTask(Act act, Act visit, boolean ignoreExisting, Party location, FlowSheetServiceFactory factory, HelpContext help) {
        super(help);
        this.act = act;
        this.visit = visit;
        this.ignoreExisting = ignoreExisting;
        IMObjectBean bean = this.getBean((IMObject)act);
        this.customer = (Party)bean.getTarget("customer", Party.class);
        this.patient = (Party)bean.getTarget("patient", Party.class);
        this.clinician = (User)bean.getTarget("clinician", User.class);
        this.location = location;
        this.factory = factory;
        this.rules = (MedicalRecordRules)ServiceHelper.getBean(MedicalRecordRules.class);
        this.contextFactory = (PatientContextFactory)ServiceHelper.getBean(PatientContextFactory.class);
    }

    protected void initialise(TaskContext context) {
        if (this.customer != null && this.patient != null && this.location != null) {
            if (this.visit == null) {
                this.visit = this.getVisit();
            }
            if (!this.visit.isNew()) {
                context.setCustomer(this.customer);
                context.setLocation(this.location);
                context.setPatient(this.patient);
                context.addObject((IMObject)this.visit);
                this.client = this.factory.getHospitalizationService(this.location);
                this.patientContext = this.getPatientContext(this.visit);
                if (!this.client.exists(this.patientContext)) {
                    Weight weight = this.patientContext.getWeight();
                    if (weight == null || weight.isZero() || DateRules.compareDateToToday((Date)weight.getDate()) != 0) {
                        this.addTask((Task)new PatientWeightTask(weight, context.getHelpContext()));
                        this.patientContext = null;
                    }
                    this.addTask((Task)new AddFlowSheet());
                    this.addTask((Task)new InformationTask(Messages.format((String)"workflow.flowsheet.created", (Object[])new Object[]{this.patient.getName()})));
                } else if (!this.ignoreExisting) {
                    this.addTask((Task)new InformationTask(Messages.format((String)"workflow.flowsheet.exists", (Object[])new Object[]{this.patient.getName()})));
                }
            } else {
                this.addTask((Task)new InformationTask(Messages.format((String)"workflow.flowsheet.novisit", (Object[])new Object[]{this.patient.getName()})));
            }
        } else {
            this.notifyCancelled();
        }
    }

    private Act getVisit() {
        return this.rules.getEventForAddition(this.patient, this.act.getActivityStartTime(), null, this.location);
    }

    private PatientContext getPatientContext(Act visit) {
        return this.contextFactory.createContext(this.patient, this.customer, visit, this.location, this.clinician);
    }

    private class AddFlowSheet
    extends AbstractTask {
        private final AppointmentRules appointmenRules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);
        private final TaskRules taskRules = (TaskRules)ServiceHelper.getBean(TaskRules.class);

        public void start(TaskContext context) {
            Weight weight;
            if (NewFlowSheetTask.this.patientContext == null) {
                NewFlowSheetTask.this.patientContext = NewFlowSheetTask.this.getPatientContext(NewFlowSheetTask.this.visit);
            }
            if ((weight = NewFlowSheetTask.this.patientContext.getWeight()) == null || weight.isZero()) {
                this.notifyCancelled();
            } else {
                final FlowSheetEditDialog dialog = new FlowSheetEditDialog(NewFlowSheetTask.this.factory, NewFlowSheetTask.this.location, -1, null, this.getDays(), false);
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        int days = dialog.getExpectedStay();
                        int departmentId = dialog.getDepartmentId();
                        String template = dialog.getTemplate();
                        try {
                            NewFlowSheetTask.this.client.add(NewFlowSheetTask.this.patientContext, days, departmentId, template);
                            AddFlowSheet.this.notifyCompleted();
                        }
                        catch (FlowSheetException exception) {
                            ErrorHandler.getInstance().error(exception.getMessage(), (Throwable)exception, () -> AddFlowSheet.this.notifyCancelled());
                        }
                        catch (Exception exception) {
                            AddFlowSheet.this.notifyCancelledOnError(exception);
                        }
                    }

                    public void onAction(String action) {
                        AddFlowSheet.this.notifyCancelled();
                    }
                });
                dialog.show();
            }
        }

        protected int getDays() {
            IMObjectBean bean;
            Entity workList;
            int days = 1;
            if (NewFlowSheetTask.this.act.isA("act.customerAppointment")) {
                days = this.appointmenRules.getBoardingDays(NewFlowSheetTask.this.act);
            } else if (NewFlowSheetTask.this.act.isA("act.customerTask") && (workList = this.taskRules.getWorkList(NewFlowSheetTask.this.act)) != null && (days = (bean = this.getBean((IMObject)workList)).getInt("expectedHospitalStay", 1)) <= 0) {
                days = 1;
            }
            return days;
        }
    }
}

