/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.util.Collection;
import java.util.Collections;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.checkin.PatientDocumentTemplateBrowser;
import org.openvpms.web.workspace.workflow.checkin.ScheduleDocumentTemplateQuery;

class DocumentPanel {
    private final Entity schedule;
    private final boolean scheduleHasTemplates;
    private final LayoutContext context;
    private final int maxResults;
    private final FocusGroup focusGroup = new FocusGroup("DocumentPanel");
    private final Component container = RowFactory.create();
    private PatientDocumentTemplateBrowser browser;

    DocumentPanel(Entity schedule, Entity worklist, LayoutContext context, int maxResults) {
        this.schedule = schedule;
        this.context = context;
        this.maxResults = maxResults;
        this.scheduleHasTemplates = ScheduleDocumentTemplateQuery.hasTemplates(schedule);
        this.addBrowser(worklist);
    }

    public void setWorkList(Entity worklist) {
        this.addBrowser(worklist);
    }

    public Collection<Entity> getTemplates() {
        return this.browser != null ? this.browser.getSelections() : Collections.emptyList();
    }

    public Component getComponent() {
        return this.container;
    }

    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    private void addBrowser(Entity worklist) {
        if (this.browser != null) {
            this.focusGroup.remove(this.browser.getFocusGroup());
        }
        this.container.removeAll();
        if (this.scheduleHasTemplates || worklist != null && ScheduleDocumentTemplateQuery.hasTemplates(worklist)) {
            ScheduleDocumentTemplateQuery query = new ScheduleDocumentTemplateQuery(this.schedule, worklist);
            query.setMaxResults(this.maxResults);
            this.browser = new TemplateBrowser(query);
            this.container.add(this.browser.getComponent());
            this.focusGroup.add(this.browser.getFocusGroup());
        } else {
            String message = this.schedule != null && worklist != null ? Messages.format((String)"workflow.checkin.print.none2", (Object[])new Object[]{this.schedule.getName(), worklist.getName()}) : (this.schedule != null ? Messages.format((String)"workflow.checkin.print.none1", (Object[])new Object[]{this.schedule.getName()}) : (worklist != null ? Messages.format((String)"workflow.checkin.print.none1", (Object[])new Object[]{worklist.getName()}) : Messages.format((String)"workflow.checkin.print.none", (Object[])new Object[0])));
            this.container.add((Component)LabelFactory.text((String)message));
        }
    }

    private class TemplateBrowser
    extends PatientDocumentTemplateBrowser {
        TemplateBrowser(ScheduleDocumentTemplateQuery query) {
            super(query, DocumentPanel.this.context);
        }

        protected void doLayout() {
            Column container = ColumnFactory.create();
            this.doLayout((Component)container);
            this.setComponent((Component)container);
            this.query();
        }

        protected PagedIMTable<Entity> createTable(IMTableModel<Entity> model) {
            return new PagedIMTable(model, false);
        }
    }
}

