/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.patient.PatientContextFactory;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.web.component.alert.MandatoryAlerts;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.clinician.ClinicianReferenceEditor;
import org.openvpms.web.component.im.edit.DefaultEditableComponentFactory;
import org.openvpms.web.component.im.edit.PatientReferenceEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientQuery;
import org.openvpms.web.component.im.patient.PatientSummaryViewer;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.AbstractSaveableEditor;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.ClinicalEventFactory;
import org.openvpms.web.workspace.workflow.checkin.DocumentPanel;
import org.openvpms.web.workspace.workflow.checkin.FlowSheetInfo;
import org.openvpms.web.workspace.workflow.checkin.FlowSheetPanel;
import org.openvpms.web.workspace.workflow.checkin.TaskPanel;
import org.openvpms.web.workspace.workflow.checkin.WeightPanel;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class CheckInEditor
extends AbstractSaveableEditor {
    private final Party customer;
    private final Entity schedule;
    private final IMObjectBean scheduleBean;
    private final Party location;
    private final Date arrivalTime;
    private final Act appointment;
    private final IArchetypeService service;
    private final SimpleProperty patientProperty = new SimpleProperty("patient", Reference.class);
    private final SimpleProperty clinicianProperty = new SimpleProperty("clinician", Reference.class);
    private final LayoutContext layoutContext;
    private final MandatoryAlerts alerts;
    private final FlowSheetServiceFactory flowSheetServiceFactory;
    private final boolean enableSmartFlow;
    private final Entity cageType;
    private final Context context;
    private final TaskPanel taskPanel;
    private final WeightPanel weightPanel;
    private final int boardingDays;
    private final ClinicalEventFactory clinicalEventFactory;
    private final PatientRules patientRules;
    private User clinician;
    private Party patient;
    private Act visit;
    private String visitError;
    private IMObjectBean visitBean;
    private Component component;
    private PatientReferenceEditor patientReferenceEditor;
    private FlowSheetPanel flowsheet;
    private DocumentPanel documents;

    CheckInEditor(Party customer, Party patient, Entity schedule, User clinician, Party location, Date arrivalTime, Act appointment, User user, HelpContext help) {
        this.service = ServiceHelper.getArchetypeService();
        this.customer = customer;
        this.patient = patient;
        this.schedule = schedule;
        this.scheduleBean = schedule != null ? this.service.getBean((IMObject)schedule) : null;
        this.clinician = clinician;
        this.location = location;
        this.arrivalTime = arrivalTime;
        this.appointment = appointment;
        AppointmentRules appointmentRules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);
        this.flowSheetServiceFactory = (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class);
        this.clinicalEventFactory = new ClinicalEventFactory(this.service, (MedicalRecordRules)ServiceHelper.getBean(MedicalRecordRules.class), appointmentRules);
        this.patientRules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
        this.cageType = this.getCageType();
        this.context = new LocalContext();
        this.context.setCustomer(customer);
        this.context.setPatient(patient);
        this.context.setSchedule(schedule);
        this.context.setClinician(clinician);
        this.context.setLocation(location);
        this.context.setUser(user);
        this.layoutContext = new DefaultLayoutContext(this.context, help);
        this.layoutContext.setComponentFactory((IMObjectComponentFactory)new DefaultEditableComponentFactory(this.layoutContext));
        this.alerts = new MandatoryAlerts(this.context, help);
        this.clinicianProperty.setDisplayName(DescriptorHelper.getDisplayName((String)"act.customerAppointment", (String)"clinician", (ArchetypeService)this.service));
        this.clinicianProperty.setArchetypeRange(new String[]{"security.user"});
        this.patientProperty.setDisplayName(DescriptorHelper.getDisplayName((String)"act.customerAppointment", (String)"patient", (ArchetypeService)this.service));
        this.patientProperty.setArchetypeRange(new String[]{"party.patientpet"});
        this.patientProperty.setRequired(true);
        if (this.selectWorkList()) {
            this.taskPanel = new TaskPanel(arrivalTime, appointment, this.layoutContext, this.service);
            this.enableSmartFlow = this.flowSheetServiceFactory.isSmartFlowSheetEnabled(location);
            this.boardingDays = appointment != null ? appointmentRules.getBoardingDays(appointment) : -1;
            this.taskPanel.setWorkListListener(this::onWorkListChanged);
        } else {
            this.taskPanel = null;
            this.enableSmartFlow = false;
            this.boardingDays = -1;
        }
        if (this.enableSmartFlow || this.getInputWeight()) {
            PatientRules rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
            PracticeService practiceService = (PracticeService)ServiceHelper.getBean(PracticeService.class);
            this.weightPanel = new WeightPanel(this.layoutContext, this.service, rules, practiceService);
        } else {
            this.weightPanel = null;
        }
        if (patient != null) {
            this.patientProperty.setValue((Object)patient.getObjectReference());
            this.updateEvent(patient);
        }
        if (clinician != null) {
            this.clinicianProperty.setValue((Object)clinician.getObjectReference());
        }
    }

    public Object getCustomer() {
        return this.customer;
    }

    public Party getPatient() {
        return this.patient;
    }

    public void setPatient(Party patient) {
        this.patientProperty.setValue(patient != null ? patient.getObjectReference() : patient);
    }

    public Entity getSchedule() {
        return this.schedule;
    }

    public Party getLocation() {
        return this.location;
    }

    public void setWorkList(Entity worklist) {
        this.taskPanel.setWorkList(worklist);
    }

    public Entity getWorkList() {
        return this.taskPanel != null ? this.taskPanel.getWorkList() : null;
    }

    public Entity getTaskType() {
        return this.taskPanel != null ? this.taskPanel.getTaskType() : null;
    }

    public void setTaskType(Entity taskType) {
        if (this.taskPanel != null) {
            this.taskPanel.setTaskType(taskType);
        }
    }

    public Act getVisit() {
        return this.visit;
    }

    public User getClinician() {
        return this.clinician;
    }

    public void setClinician(User clinician) {
        this.clinicianProperty.setValue(clinician != null ? clinician.getObjectReference() : clinician);
    }

    public Date getArrivalTime() {
        return this.arrivalTime;
    }

    public FlowSheetInfo getFlowSheetInfo() {
        return this.flowsheet != null && this.flowsheet.createFlowSheet() ? new FlowSheetInfo(this.flowsheet.getDepartmentId(), this.flowsheet.getExpectedStay(), this.flowsheet.getTemplate()) : null;
    }

    public Collection<Entity> getTemplates() {
        return this.documents.getTemplates();
    }

    public Act getWeightRecord() {
        return this.weightPanel != null ? this.weightPanel.getWeightRecord() : null;
    }

    public Act getAppointment() {
        return this.appointment;
    }

    public Act getTask() {
        return this.taskPanel != null ? this.taskPanel.getTask() : null;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = this.doLayout();
        }
        return this.component;
    }

    public void showAlerts() {
        if (this.customer != null) {
            this.alerts.show(this.customer);
        }
        if (this.patient != null) {
            this.alerts.show(this.patient);
        }
    }

    public boolean isModified() {
        return true;
    }

    public void setWeight(BigDecimal weight) {
        if (this.weightPanel != null) {
            this.weightPanel.setWeight(weight);
        }
    }

    public void setWeight(BigDecimal weight, WeightUnits units) {
        if (this.weightPanel != null) {
            this.weightPanel.setWeight(weight);
            this.weightPanel.setUnits(units);
        }
    }

    public BigDecimal getWeight() {
        return this.weightPanel != null ? this.weightPanel.getWeight() : null;
    }

    public CheckInEditor newInstance() {
        Party newCustomer = this.reload(this.customer);
        Act newAppointment = this.reload(this.appointment);
        if (newAppointment != null) {
            IMObjectBean bean = this.service.getBean((IMObject)newAppointment);
            if (!Objects.equals(newCustomer.getObjectReference(), bean.getTargetRef("customer"))) {
                throw new IllegalStateException("The appointment customer has changed");
            }
        }
        Party newPatient = this.reload(this.patient);
        Entity newSchedule = this.reload(this.schedule);
        User newClinician = this.reload(this.clinician);
        Party newLocation = this.reload(this.location);
        User newUser = this.reload(this.context.getUser());
        CheckInEditor editor = new CheckInEditor(newCustomer, newPatient, newSchedule, newClinician, newLocation, this.arrivalTime, newAppointment, newUser, this.layoutContext.getHelpContext());
        editor.getComponent();
        if (this.weightPanel != null) {
            editor.setWeight(this.weightPanel.getWeight(), this.weightPanel.getUnits());
        }
        editor.setWorkList(this.getWorkList());
        editor.setTaskType(this.getTaskType());
        return editor;
    }

    public User getUser() {
        return this.context.getUser();
    }

    protected boolean doValidation(Validator validator) {
        return this.validatePatient(validator) && validator.validate((Modifiable)this.clinicianProperty) && this.validateVisit(validator) && this.validateWeight(validator) && this.validateTask(validator) && this.validateFlowSheet(validator);
    }

    protected void doSave() {
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)ServiceHelper.getBean(PlatformTransactionManager.class);
        TransactionTemplate template = new TransactionTemplate(transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                CheckInEditor.this.saveVisit();
                CheckInEditor.this.saveWeight();
                CheckInEditor.this.saveTask();
            }
        });
    }

    protected Component doLayout() {
        FocusGroup focus = this.getFocusGroup();
        ComponentGrid grid = new ComponentGrid();
        this.patientReferenceEditor = new PatientReferenceEditor((Property)this.patientProperty, null, this.layoutContext){

            protected Query<Party> createQuery(String name) {
                PatientQuery query = new PatientQuery(CheckInEditor.this.customer);
                query.setValue(name);
                return query;
            }
        };
        this.patientReferenceEditor.setAllowCreate(true);
        Button info = PatientSummaryViewer.createButton((LayoutContext)this.layoutContext, this::getPatient);
        Row patientRow = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{this.patientReferenceEditor.getComponent(), info});
        Label customerLabel = LabelFactory.text((String)DescriptorHelper.getDisplayName((String)"act.customerAppointment", (String)"customer", (ArchetypeService)this.service));
        grid.add(new Component[]{LabelFactory.text((String)this.patientProperty.getDisplayName()), patientRow, customerLabel, LabelFactory.text((String)this.customer.getName())});
        focus.add(this.patientReferenceEditor.getFocusGroup());
        ClinicianReferenceEditor clinicianReferenceEditor = new ClinicianReferenceEditor((Property)this.clinicianProperty, null, this.layoutContext);
        grid.add(new Component[]{LabelFactory.text((String)this.clinicianProperty.getDisplayName()), clinicianReferenceEditor.getComponent()});
        focus.add(clinicianReferenceEditor.getFocusGroup());
        if (this.weightPanel != null) {
            this.weightPanel.setPatient(this.patient);
            focus.add(this.weightPanel.layout(grid));
        }
        if (this.taskPanel != null) {
            this.taskPanel.setPatient(this.patient);
            focus.add(this.taskPanel.layout(grid));
        }
        if (this.enableSmartFlow) {
            grid.add(new Component[]{TableHelper.createSpacer()});
            grid.add(new Component[]{LabelFactory.create((String)"workflow.checkin.smartflow", (String)"bold")});
            int days = Math.max(this.boardingDays, 1);
            this.flowsheet = new FlowSheetPanel(this.flowSheetServiceFactory, this.location, -1, null, days, true, this.service);
            this.flowsheet.layout(grid, 4);
            this.flowsheet.setCreateFlowSheet(false);
            focus.add(this.flowsheet.getFocusGroup());
        }
        grid.add(new Component[]{TableHelper.createSpacer()});
        grid.add(new Component[]{LabelFactory.create((String)"workflow.checkin.print", (String)"bold")});
        int maxResults = this.enableSmartFlow ? 7 : 10;
        this.documents = new DocumentPanel(this.schedule, this.getWorkList(), this.layoutContext, maxResults);
        grid.add(this.documents.getComponent(), 4);
        focus.add(this.documents.getFocusGroup());
        this.patientProperty.addModifiableListener(modifiable -> this.onPatientChanged());
        this.clinicianProperty.addModifiableListener(modifiable -> this.onClinicianChanged());
        focus.setFocus();
        return grid.createGrid();
    }

    PatientReferenceEditor getPatientReferenceEditor() {
        return this.patientReferenceEditor;
    }

    Editor getWorkListEditor() {
        return this.taskPanel != null ? this.taskPanel.getWorkListEditor() : null;
    }

    private <T extends IMObject> T reload(T object) {
        return (T)IMObjectHelper.reload(object, (boolean)true);
    }

    private boolean validatePatient(Validator validator) {
        boolean valid = validator.validate((Modifiable)this.patientProperty);
        if (valid && !this.patientRules.isOwner(this.customer, this.patient)) {
            valid = false;
            validator.add((Modifiable)this.patientProperty, Messages.format((String)"workflow.checkin.invalidpatient", (Object[])new Object[]{this.patient.getName(), this.customer.getName()}));
        }
        return valid;
    }

    private boolean validateVisit(Validator validator) {
        boolean valid = false;
        if (this.visit == null) {
            String message = StringUtils.isEmpty((CharSequence)this.visitError) ? Messages.format((String)"property.error.required", (Object[])new Object[]{DescriptorHelper.getDisplayName((String)"act.patientClinicalEvent", (ArchetypeService)this.service)}) : this.visitError;
            validator.add((Modifiable)this, new ValidatorError(message));
        } else {
            valid = true;
        }
        return valid;
    }

    private boolean validateTask(Validator validator) {
        return this.taskPanel == null || this.taskPanel.validate(validator);
    }

    private boolean validateWeight(Validator validator) {
        return this.weightPanel == null || this.weightPanel.validate(validator);
    }

    private boolean validateFlowSheet(Validator validator) {
        boolean result = false;
        if (this.enableSmartFlow && this.flowsheet.createFlowSheet()) {
            if (this.weightPanel.isZero() || !this.weightPanel.isWeightCurrent()) {
                validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"workflow.checkin.weight.smartflow")));
            } else if (this.visit != null && !this.visit.isNew()) {
                PatientContextFactory factory = (PatientContextFactory)ServiceHelper.getBean(PatientContextFactory.class);
                PatientContext patientContext = factory.createContext(this.patient, this.visit, this.location);
                if (this.flowSheetServiceFactory.getHospitalizationService(this.location).exists(patientContext)) {
                    validator.add((Modifiable)this, new ValidatorError(Messages.format((String)"workflow.flowsheet.exists", (Object[])new Object[]{this.patient.getName()})));
                    this.flowsheet.setCreateFlowSheet(false);
                } else {
                    result = true;
                }
            } else {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    private Entity getCageType() {
        return this.scheduleBean != null ? (Entity)this.scheduleBean.getTarget("cageType", Entity.class, Policies.active()) : null;
    }

    private boolean getInputWeight() {
        return this.scheduleBean != null && this.scheduleBean.getBoolean("inputWeight", true);
    }

    private boolean selectWorkList() {
        boolean useAllWorkLists;
        boolean result = true;
        if (this.scheduleBean != null && !(useAllWorkLists = this.scheduleBean.getBoolean("useAllWorkLists", true))) {
            result = !this.scheduleBean.getValues("workLists").isEmpty();
        }
        return result;
    }

    private void saveVisit() {
        IMObjectBean appointmentBean = this.appointment != null ? this.service.getBean((IMObject)this.appointment) : null;
        boolean patientChanged = false;
        if (appointmentBean != null) {
            boolean bl = patientChanged = !Objects.equals(this.patient.getObjectReference(), appointmentBean.getTargetRef("patient"));
        }
        if (this.visit.isNew() || patientChanged) {
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            ArrayList<Act> toSave = new ArrayList<Act>();
            if (this.visit.isNew()) {
                toSave.add(this.visit);
            }
            if (appointmentBean != null) {
                if (patientChanged) {
                    appointmentBean.setTarget("patient", (IMObject)this.patient);
                }
                if (this.visit.isNew()) {
                    Relationship relationship = appointmentBean.setTarget("event", (IMObject)this.visit);
                    this.visitBean.addValue("appointment", (IMObject)relationship);
                }
                toSave.add(this.appointment);
            }
            service.save(toSave);
        }
    }

    private void saveWeight() {
        if (this.weightPanel != null) {
            this.weightPanel.save(this.visit);
        }
    }

    private void saveTask() {
        if (this.taskPanel != null) {
            this.taskPanel.save();
        }
    }

    private void onPatientChanged() {
        this.patient = (Party)this.layoutContext.getCache().get(this.patientProperty.getReference());
        this.context.setPatient(this.patient);
        this.updateEvent(this.patient);
        if (this.weightPanel != null) {
            this.weightPanel.setPatient(this.patient);
        }
        if (this.taskPanel != null) {
            this.taskPanel.setPatient(this.patient);
        }
        if (this.patient != null) {
            this.alerts.show(this.patient);
        }
    }

    private void updateEvent(Party patient) {
        if (patient != null) {
            try {
                String reason = this.appointment != null ? this.appointment.getReason() : null;
                boolean newEvent = this.cageType != null;
                this.visit = this.clinicalEventFactory.getEvent(this.arrivalTime, patient, this.clinician, this.appointment, reason, this.location, newEvent);
                this.visitBean = this.visit.isNew() ? this.service.getBean((IMObject)this.visit) : null;
                this.visitError = null;
            }
            catch (IllegalStateException exception) {
                this.visit = null;
                this.visitBean = null;
                this.visitError = exception.getMessage();
            }
        } else {
            this.visit = null;
            this.visitBean = null;
        }
    }

    private void onWorkListChanged() {
        Entity worklist = this.taskPanel.getWorkList();
        Component focus = FocusHelper.getFocus();
        if (this.enableSmartFlow) {
            if (worklist != null) {
                this.flowsheet.setWorkList(worklist);
                int expectedHospitalStay = this.flowsheet.getExpectedStay();
                int days = Math.max(this.boardingDays, expectedHospitalStay);
                if (days != expectedHospitalStay) {
                    this.flowsheet.setExpectedStay(days);
                }
            } else {
                this.flowsheet.setCreateFlowSheet(false);
            }
        }
        this.documents.setWorkList(worklist);
        if (focus != null) {
            FocusHelper.setFocus((Component)focus);
        }
    }

    private void onClinicianChanged() {
        this.clinician = (User)this.layoutContext.getCache().get(this.clinicianProperty.getReference());
        if (this.visit != null && this.visit.isNew()) {
            this.visitBean.setTarget("clinician", (IMObject)this.clinician);
        }
        if (this.taskPanel != null) {
            this.taskPanel.setClinician(this.clinician);
        }
        if (this.weightPanel != null) {
            this.weightPanel.setClinician(this.clinician);
        }
    }
}

