/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import org.apache.commons.collections4.Predicate;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;

class RepeatUntilDateCondition
implements RepeatCondition {
    private final Date date;

    public RepeatUntilDateCondition(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RepeatUntilDateCondition) {
            return DateRules.dateEquals((Date)this.date, (Date)((RepeatUntilDateCondition)obj).getDate());
        }
        return false;
    }

    @Override
    public Predicate<Date> create() {
        return new Predicate<Date>(){

            public boolean evaluate(Date object) {
                return DateRules.compareDates((Date)object, (Date)RepeatUntilDateCondition.this.date) <= 0;
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(Messages.get((String)"workflow.scheduling.appointment.until"));
        result.append(" ");
        result.append(DateFormatter.getFullDateFormat().format(this.date));
        return result.toString();
    }
}

