/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import java.util.GregorianCalendar;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SelectField;
import org.joda.time.DateTime;
import org.openvpms.web.component.bound.SpinBox;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatOnNthDayEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.MonthSelectField;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;

class RepeatOnNthDayInMonthEditor
extends AbstractRepeatOnNthDayEditor {
    private SimpleProperty month = new SimpleProperty("month", Integer.class);

    public RepeatOnNthDayInMonthEditor(Date startTime) {
        super(startTime);
        if (startTime != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(startTime);
            this.month.setValue((Object)(calendar.get(2) + 1));
            this.setInterval(1);
        }
    }

    public RepeatOnNthDayInMonthEditor(CronRepeatExpression expression) {
        super(expression);
        this.month.setValue((Object)expression.getMonth().month());
        this.setInterval(expression.getYear().getInterval());
    }

    @Override
    public Component getComponent() {
        SelectField ordinalField = this.createOrdinalSelector();
        SelectField dayField = this.createDaySelector();
        MonthSelectField monthField = new MonthSelectField((Property)this.month);
        Label every = LabelFactory.create();
        every.setText(Messages.get((String)"workflow.scheduling.appointment.every").toLowerCase());
        SpinBox intervalField = this.createIntervalField();
        FocusGroup focusGroup = this.getFocusGroup();
        focusGroup.add((Component)ordinalField);
        focusGroup.add((Component)dayField);
        focusGroup.add((Component)monthField);
        focusGroup.add((Component)intervalField);
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"workflow.scheduling.appointment.onthe"), ordinalField, dayField, LabelFactory.create((String)"workflow.scheduling.appointment.of"), monthField, every, intervalField, LabelFactory.create((String)"workflow.scheduling.appointment.years")});
    }

    @Override
    public RepeatExpression getExpression() {
        Date startTime = this.getStartTime();
        CronRepeatExpression.DayOfWeek dayOfWeek = this.getDayOfWeek();
        if (startTime != null && dayOfWeek != null) {
            DateTime time = new DateTime((Object)startTime);
            return new CronRepeatExpression(startTime, CronRepeatExpression.Month.month(this.month.getInt()), dayOfWeek, CronRepeatExpression.Year.every(time.getYear(), this.getInterval()));
        }
        return null;
    }

    public static boolean supports(CronRepeatExpression expression) {
        CronRepeatExpression.DayOfWeek dayOfWeek = expression.getDayOfWeek();
        CronRepeatExpression.DayOfMonth dayOfMonth = expression.getDayOfMonth();
        CronRepeatExpression.Month month = expression.getMonth();
        CronRepeatExpression.Year year = expression.getYear();
        return dayOfWeek.isOrdinal() && dayOfMonth.isAll() && month.singleMonth() && year.getInterval() != -1;
    }
}

