/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SelectField;
import org.joda.time.DateTime;
import org.openvpms.web.component.bound.SpinBox;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatOnNthDayEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;

class RepeatOnNthDayEditor
extends AbstractRepeatOnNthDayEditor {
    public RepeatOnNthDayEditor(Date startTime) {
        super(startTime);
    }

    public RepeatOnNthDayEditor(CronRepeatExpression expression) {
        super(expression);
        CronRepeatExpression.Month month = expression.getMonth();
        this.setInterval(month.getInterval());
    }

    @Override
    public Component getComponent() {
        SelectField ordinalField = this.createOrdinalSelector();
        SelectField dayField = this.createDaySelector();
        Label the = LabelFactory.create((String)"workflow.scheduling.appointment.onthe");
        Label every = LabelFactory.create();
        every.setText(Messages.get((String)"workflow.scheduling.appointment.every").toLowerCase());
        Label label = LabelFactory.create((String)"workflow.scheduling.appointment.months");
        SpinBox intervalField = this.createIntervalField();
        FocusGroup focusGroup = this.getFocusGroup();
        focusGroup.add((Component)ordinalField);
        focusGroup.add((Component)dayField);
        focusGroup.add((Component)intervalField);
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[]{the, ordinalField, dayField, every, intervalField, label});
    }

    @Override
    public RepeatExpression getExpression() {
        Date startTime = this.getStartTime();
        CronRepeatExpression.DayOfWeek dayOfWeek = this.getDayOfWeek();
        if (startTime != null && dayOfWeek != null) {
            DateTime time = new DateTime((Object)startTime);
            return new CronRepeatExpression(startTime, CronRepeatExpression.Month.every(time.getMonthOfYear(), this.getInterval()), dayOfWeek);
        }
        return null;
    }

    public static boolean supports(CronRepeatExpression expression) {
        CronRepeatExpression.DayOfWeek dayOfWeek = expression.getDayOfWeek();
        CronRepeatExpression.DayOfMonth dayOfMonth = expression.getDayOfMonth();
        CronRepeatExpression.Month month = expression.getMonth();
        return dayOfWeek.isOrdinal() && dayOfMonth.isAll() && month.getInterval() != -1;
    }
}

