/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import nextapp.echo2.app.Component;
import org.openvpms.web.component.bound.SpinBox;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.NumericPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatUntilEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatNTimesCondition;

public class RepeatNTimesEditor
extends AbstractRepeatUntilEditor {
    private final int maxRepeats;

    public RepeatNTimesEditor(int times, int maxRepeats) {
        this(null, maxRepeats);
        this.getProperty().setValue((Object)times);
    }

    public RepeatNTimesEditor(RepeatNTimesCondition condition, int maxRepeats) {
        super((Property)new SimpleProperty("times", Integer.class));
        this.maxRepeats = maxRepeats;
        SimpleProperty times = (SimpleProperty)this.getProperty();
        times.setRequired(true);
        times.setTransformer((PropertyTransformer)new NumericPropertyTransformer((Property)times, true));
        if (condition != null) {
            times.setValue((Object)condition.getTimes());
        }
    }

    @Override
    public RepeatCondition getCondition() {
        Property times = this.getProperty();
        return times.isValid() ? new RepeatNTimesCondition(times.getInt()) : null;
    }

    @Override
    public Component getComponent() {
        SpinBox field = new SpinBox(this.getProperty(), 1, this.maxRepeats);
        this.getFocusGroup().add((Component)field);
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[]{field, LabelFactory.create((String)"workflow.scheduling.appointment.times")});
    }

    protected boolean doValidation(Validator validator) {
        boolean result = super.doValidation(validator);
        if (result && this.getProperty().getInt() > this.maxRepeats) {
            validator.add((Modifiable)this, new ValidatorError(Messages.format((String)"workflow.scheduling.appointment.maxrepeats", (Object[])new Object[]{this.maxRepeats})));
            result = false;
        }
        return result;
    }
}

