/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import org.apache.commons.collections4.Predicate;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.TimesPredicate;

class RepeatNTimesCondition
implements RepeatCondition {
    private final int times;

    public RepeatNTimesCondition(int times) {
        this.times = times;
    }

    public int getTimes() {
        return this.times;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RepeatNTimesCondition) {
            return this.times == ((RepeatNTimesCondition)obj).getTimes();
        }
        return false;
    }

    @Override
    public Predicate<Date> create() {
        return new TimesPredicate<Date>(this.times);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        switch (this.times) {
            case 1: {
                result.append(Messages.get((String)"workflow.scheduling.appointment.once"));
                break;
            }
            case 2: {
                result.append(Messages.get((String)"workflow.scheduling.appointment.twice"));
                break;
            }
            default: {
                result.append(this.times);
                result.append(" ");
                result.append(Messages.get((String)"workflow.scheduling.appointment.times"));
            }
        }
        return result.toString();
    }
}

