/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.CalendarRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.Repeats;

class RepeatHelper {
    RepeatHelper() {
    }

    public static RepeatExpression getExpression(IMObjectBean series) {
        RepeatExpression result = null;
        int interval = series.getInt("interval", -1);
        DateUnits units = DateUnits.fromString((String)series.getString("units"));
        if (interval != -1 && units != null) {
            result = new CalendarRepeatExpression(interval, units);
        } else {
            String expression = series.getString("expression");
            if (!StringUtils.isEmpty((CharSequence)expression)) {
                result = CronRepeatExpression.parse(expression);
            }
        }
        return result;
    }

    public static RepeatCondition getCondition(IMObjectBean series, int count) {
        RepeatCondition result = null;
        int times = series.getInt("times", -1);
        Date endTime = ((Act)series.getObject(Act.class)).getActivityEndTime();
        if (times > 0) {
            if (count > 0) {
                times -= count;
            }
            result = Repeats.times(times);
        } else if (endTime != null) {
            result = Repeats.until(endTime);
        }
        return result;
    }

    public static String toString(RepeatExpression.Type type) {
        String result;
        switch (type) {
            case DAILY: {
                result = Messages.get((String)"workflow.scheduling.appointment.daily");
                break;
            }
            case WEEKDAYS: {
                result = Messages.get((String)"workflow.scheduling.appointment.weekdays");
                break;
            }
            case WEEKLY: {
                result = Messages.get((String)"workflow.scheduling.appointment.weekly");
                break;
            }
            case MONTHLY: {
                result = Messages.get((String)"workflow.scheduling.appointment.monthly");
                break;
            }
            case YEARLY: {
                result = Messages.get((String)"workflow.scheduling.appointment.yearly");
                break;
            }
            default: {
                result = WordUtils.capitalizeFully((String)type.name());
            }
        }
        return result;
    }

    public static String toString(DateUnits units) {
        String result;
        switch (units) {
            case DAYS: {
                result = Messages.get((String)"workflow.scheduling.appointment.days");
                break;
            }
            case WEEKS: {
                result = Messages.get((String)"workflow.scheduling.appointment.weeks");
                break;
            }
            case MONTHS: {
                result = Messages.get((String)"workflow.scheduling.appointment.months");
                break;
            }
            case YEARS: {
                result = Messages.get((String)"workflow.scheduling.appointment.years");
                break;
            }
            default: {
                result = WordUtils.capitalizeFully((String)units.toString().toLowerCase());
            }
        }
        return result;
    }
}

