/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.text.ParseException;
import java.util.BitSet;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.quartz.CronExpression;

public class CronRepeatExpression
implements RepeatExpression {
    private final String minutes;
    private final String hours;
    private final DayOfMonth dayOfMonth;
    private final Month month;
    private final DayOfWeek dayOfWeek;
    private final Year year;
    private final RepeatExpression.Type type;
    private CronExpression expression;
    private static final Log log = LogFactory.getLog(CronRepeatExpression.class);

    public CronRepeatExpression(Date startTime, DayOfWeek dayOfWeek) {
        this(startTime, DayOfMonth.NO_VALUE, Month.ALL, dayOfWeek, Year.ALL, RepeatExpression.Type.CUSTOM);
    }

    public CronRepeatExpression(Date startTime, Month month, DayOfWeek dayOfWeek) {
        this(startTime, DayOfMonth.NO_VALUE, month, dayOfWeek, Year.ALL, RepeatExpression.Type.CUSTOM);
    }

    public CronRepeatExpression(Date startTime, DayOfMonth dayOfMonth, Month month) {
        this(startTime, dayOfMonth, month, DayOfWeek.NO_VALUE, Year.ALL, RepeatExpression.Type.CUSTOM);
    }

    public CronRepeatExpression(Date startTime, Month month, DayOfWeek dayOfWeek, Year year) {
        this(startTime, DayOfMonth.NO_VALUE, month, dayOfWeek, year, RepeatExpression.Type.CUSTOM);
    }

    public CronRepeatExpression(Date startTime, DayOfMonth dayOfMonth, Month month, Year year) {
        this(startTime, dayOfMonth, month, DayOfWeek.NO_VALUE, year, RepeatExpression.Type.CUSTOM);
    }

    private CronRepeatExpression(Date startTime, DayOfMonth dayOfMonth, Month month, DayOfWeek dayOfWeek, Year year, RepeatExpression.Type type) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startTime);
        this.minutes = "" + calendar.get(12);
        this.hours = "" + calendar.get(11);
        this.dayOfMonth = dayOfMonth;
        this.month = month;
        this.dayOfWeek = dayOfWeek;
        this.year = year;
        this.type = type;
    }

    private CronRepeatExpression(int minute, int hour, DayOfMonth dayOfMonth, Month month, DayOfWeek dayOfWeek, Year year, RepeatExpression.Type type) {
        this.minutes = "" + minute;
        this.hours = "" + hour;
        this.dayOfMonth = dayOfMonth;
        this.month = month;
        this.dayOfWeek = dayOfWeek;
        this.type = type;
        this.year = year;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public String getHours() {
        return this.hours;
    }

    public DayOfMonth getDayOfMonth() {
        return this.dayOfMonth;
    }

    public Month getMonth() {
        return this.month;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    public Year getYear() {
        return this.year;
    }

    @Override
    public RepeatExpression.Type getType() {
        return this.type;
    }

    public String getExpression() {
        StringBuilder result = new StringBuilder();
        result.append("0 ");
        result.append(this.minutes);
        result.append(" ");
        result.append(this.hours);
        result.append(" ");
        result.append(this.dayOfMonth.value);
        result.append(" ");
        result.append(this.month.value);
        result.append(" ");
        result.append(this.dayOfWeek.value);
        result.append(" ");
        result.append(this.year.value);
        return result.toString();
    }

    @Override
    public Date getRepeatAfter(Date time, Predicate<Date> condition) {
        Date result = null;
        if (this.expression == null) {
            try {
                this.expression = new CronExpression(this.getExpression());
            }
            catch (ParseException exception) {
                log.error((Object)exception, (Throwable)exception);
            }
        }
        if (this.expression != null) {
            result = (time = this.expression.getNextValidTimeAfter(time)) != null && condition.evaluate((Object)time) ? time : null;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CronRepeatExpression) {
            CronRepeatExpression other = (CronRepeatExpression)obj;
            return Objects.equals(this.minutes, other.minutes) && Objects.equals(this.hours, other.hours) && Objects.equals(this.dayOfMonth, other.dayOfMonth) && Objects.equals(this.month, other.month) && Objects.equals(this.dayOfWeek, other.dayOfWeek) && Objects.equals(this.year, other.year);
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        return builder.append((Object)this.minutes).append((Object)this.hours).append((Object)this.dayOfMonth).append((Object)this.month).append((Object)this.dayOfWeek).append((Object)this.year).hashCode();
    }

    public static CronRepeatExpression parse(String expression) {
        CronRepeatExpression result;
        String[] parts = expression.split(" ");
        if (parts.length < 6) {
            return null;
        }
        try {
            int minute = CronRepeatExpression.parseInt(parts[1], 0, 59, "minutes");
            int hour = CronRepeatExpression.parseInt(parts[2], 0, 23, "hours");
            String dayOfMonth = parts[3];
            String month = parts[4];
            String dayOfWeek = parts[5];
            String year = parts.length > 6 ? parts[6] : Year.ALL.value;
            result = CronRepeatExpression.parse(minute, hour, dayOfMonth, month, dayOfWeek, year);
        }
        catch (Throwable exception) {
            log.warn((Object)exception, exception);
            return null;
        }
        return result;
    }

    public static RepeatExpression weekdays(Date startTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startTime);
        return new CronRepeatExpression(startTime, DayOfMonth.NO_VALUE, Month.ALL, DayOfWeek.WEEKDAYS, Year.ALL, RepeatExpression.Type.WEEKDAYS);
    }

    private static CronRepeatExpression parse(int minute, int hour, String dayOfMonth, String month, String dayOfWeek, String year) {
        DayOfMonth dom = DayOfMonth.parse(dayOfMonth);
        Month m = Month.parse(month);
        DayOfWeek dow = DayOfWeek.parse(dayOfWeek);
        Year y = Year.parse(year);
        boolean allDayOfMonth = dom.isAll();
        boolean allMonth = m.isAll();
        boolean allDayOfWeek = dow.isAll();
        RepeatExpression.Type type = allDayOfMonth && allMonth && allDayOfWeek ? RepeatExpression.Type.DAILY : (allDayOfMonth && allMonth && dow.weekdays() ? RepeatExpression.Type.WEEKDAYS : (allDayOfMonth && allMonth && dow.singleDay() ? RepeatExpression.Type.WEEKLY : (dom.singleDay() && allMonth && allDayOfWeek ? RepeatExpression.Type.MONTHLY : (dom.singleDay() && m.singleMonth() && allDayOfWeek ? RepeatExpression.Type.YEARLY : RepeatExpression.Type.CUSTOM))));
        CronRepeatExpression result = new CronRepeatExpression(minute, hour, dom, m, dow, y, type);
        return result;
    }

    private static int parseInt(String value, int min, int max, String displayName) {
        int result;
        try {
            result = Integer.valueOf(value);
            if (result < min || result > max) {
                throw new IllegalArgumentException("Invalid " + displayName + ": " + value);
            }
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("Invalid " + displayName + ": " + value);
        }
        return result;
    }

    private static abstract class Field {
        protected final String value;

        public Field(String value) {
            this.value = value;
        }

        public boolean isAll() {
            return "*".equals(this.value) || "?".equals(this.value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Field) {
                Field other = (Field)obj;
                return Objects.equals(this.value, other.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static class Year
    extends Field {
        private final int year;
        private final int interval;
        public static final Year ALL = new Year("*");
        private static final Pattern YEAR_INTERVAL = Pattern.compile("(\\d+)\\/(\\d+)");

        private Year(String value) {
            super(value);
            this.year = -1;
            this.interval = -1;
        }

        private Year(int year, int interval) {
            super(year + "/" + interval);
            this.year = year;
            this.interval = interval;
        }

        public int year() {
            return this.year;
        }

        public int getInterval() {
            return this.interval;
        }

        public static Year every(int year, int interval) {
            return new Year(year, interval);
        }

        public static Year parse(String value) {
            Matcher matcher = YEAR_INTERVAL.matcher(value);
            if (matcher.matches()) {
                int year = Integer.parseInt(matcher.group(1));
                int interval = Integer.parseInt(matcher.group(2));
                return new Year(year, interval);
            }
            return new Year(value);
        }
    }

    public static class DayOfWeek
    extends Field {
        public static final DayOfWeek NO_VALUE;
        public static final DayOfWeek ALL;
        public static final DayOfWeek WEEKDAYS;
        public static final int LAST = -1;
        private final BitSet set;
        private final int ordindal;
        private static final String SUN = "SUN";
        private static final String MON = "MON";
        private static final String TUE = "TUE";
        private static final String WED = "WED";
        private static final String THU = "THU";
        private static final String FRI = "FRI";
        private static final String SAT = "SAT";
        private static final BidiMap<String, Integer> DAY_ID;
        private static final BidiMap<Integer, String> ID_DAY;

        private DayOfWeek(String value) {
            this(value, new BitSet());
        }

        private DayOfWeek(String value, BitSet set) {
            super(value);
            this.set = set;
            this.ordindal = 0;
        }

        private DayOfWeek(List<String> days) {
            super(StringUtils.join(days.iterator(), (String)","));
            this.set = new BitSet();
            for (String day : days) {
                this.set.set(DayOfWeek.getDay(day), true);
            }
            this.ordindal = 0;
        }

        private DayOfWeek(String day, int ordinal) {
            super(ordinal == -1 ? day + "L" : day + "#" + ordinal);
            this.set = new BitSet(7);
            this.set.set(DayOfWeek.getDay(day));
            this.ordindal = ordinal;
        }

        public int getOrdinal() {
            return this.ordindal;
        }

        public boolean weekdays() {
            return this.set.get(2, 7).cardinality() == 5 && !this.set.get(1) && !this.set.get(7);
        }

        public boolean weekends() {
            return this.set.get(2, 7).cardinality() == 0 && this.set.get(1) && this.set.get(7);
        }

        @Override
        public boolean isAll() {
            return super.isAll() || this.set.cardinality() == 7;
        }

        public boolean isSelected(int day) {
            return this.set.get(day);
        }

        public boolean singleDay() {
            return this.set.cardinality() == 1;
        }

        public int day() {
            return this.set.nextSetBit(0);
        }

        public boolean isOrdinal() {
            return this.ordindal > 0 || this.ordindal == -1;
        }

        public String getDay() {
            if (this.set.cardinality() == 1) {
                return (String)ID_DAY.get((Object)this.set.nextSetBit(0));
            }
            return null;
        }

        public static DayOfWeek days(List<String> days) {
            return new DayOfWeek(days);
        }

        public static DayOfWeek nth(String day, int ordinal) {
            return new DayOfWeek(day, ordinal);
        }

        public static DayOfWeek last(String day) {
            return new DayOfWeek(day + "L");
        }

        public static DayOfWeek parse(String value) {
            BitSet set = new BitSet();
            if (value.contains("-")) {
                String[] parts = value.split("-");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Invalid day of week: " + value);
                }
                int start = DayOfWeek.getDay(parts[0]);
                int end = DayOfWeek.getDay(parts[1]);
                set.set(start, end + 1, true);
                return new DayOfWeek(value, set);
            }
            if (value.contains(",")) {
                String[] parts;
                for (String part : parts = value.split(",")) {
                    set.set(DayOfWeek.getDay(part), true);
                }
                return new DayOfWeek(value, set);
            }
            if (value.contains("#")) {
                String[] parts = value.split("#");
                if (parts.length == 2) {
                    int nth = CronRepeatExpression.parseInt(parts[1], 1, 4, "count");
                    return new DayOfWeek(parts[0], nth);
                }
                throw new IllegalArgumentException("Invalid day of week: " + value);
            }
            if (value.endsWith("L")) {
                value = value.substring(0, value.length() - 1);
                return new DayOfWeek(value, -1);
            }
            Integer day = DayOfWeek.getCalendarDay(value);
            if (day != null) {
                set.set(day);
                return new DayOfWeek(value, set);
            }
            return new DayOfWeek(value);
        }

        public static String getDay(int dayOfWeek) {
            switch (dayOfWeek) {
                case 1: {
                    return SUN;
                }
                case 2: {
                    return MON;
                }
                case 3: {
                    return TUE;
                }
                case 4: {
                    return WED;
                }
                case 5: {
                    return THU;
                }
                case 6: {
                    return FRI;
                }
                case 7: {
                    return SAT;
                }
            }
            return null;
        }

        private static int getDay(String day) {
            Integer result = DayOfWeek.getCalendarDay(day);
            if (result == null) {
                throw new IllegalArgumentException("Invalid day: " + day);
            }
            return result;
        }

        private static Integer getCalendarDay(String day) {
            return (Integer)DAY_ID.get((Object)day.toUpperCase());
        }

        static {
            DAY_ID = new DualHashBidiMap();
            DAY_ID.put((Object)SUN, (Object)1);
            DAY_ID.put((Object)MON, (Object)2);
            DAY_ID.put((Object)TUE, (Object)3);
            DAY_ID.put((Object)WED, (Object)4);
            DAY_ID.put((Object)THU, (Object)5);
            DAY_ID.put((Object)FRI, (Object)6);
            DAY_ID.put((Object)SAT, (Object)7);
            ID_DAY = DAY_ID.inverseBidiMap();
            NO_VALUE = new DayOfWeek("?");
            ALL = new DayOfWeek("*");
            BitSet set = new BitSet(7);
            set.set(2, 7, true);
            WEEKDAYS = new DayOfWeek("MON-FRI", set);
        }
    }

    public static class Month
    extends Field {
        public static Month ALL = new Month("*");
        private final BitSet set = new BitSet();
        private final int interval;
        private static final Pattern MONTH_INTERVAL = Pattern.compile("(\\d+)\\/(\\d+)");

        private Month(int month, int interval) {
            this(interval != -1 ? "" + month + "/" + interval : "" + month, interval);
            if (month != -1) {
                this.set.set(month, true);
            }
        }

        private Month(String value) {
            this(value, -1);
        }

        private Month(String value, int interval) {
            super(value);
            this.interval = interval;
        }

        public boolean singleMonth() {
            return StringUtils.isNumeric((CharSequence)this.value);
        }

        public int getInterval() {
            return this.interval;
        }

        public int month() {
            return this.set.nextSetBit(0);
        }

        public static Month month(int month) {
            return new Month(month, -1);
        }

        public static Month every(int month, int interval) {
            return new Month(month, interval);
        }

        public static Month parse(String value) {
            Matcher matcher = MONTH_INTERVAL.matcher(value);
            if (matcher.matches()) {
                int month = Integer.parseInt(matcher.group(1));
                int interval = Integer.parseInt(matcher.group(2));
                return new Month(month, interval);
            }
            if (StringUtils.isNumeric((CharSequence)value)) {
                return new Month(Integer.parseInt(value), -1);
            }
            return new Month(value);
        }
    }

    public static class DayOfMonth
    extends Field {
        public static DayOfMonth NO_VALUE = new DayOfMonth("?");
        private final BitSet set;
        private final boolean last;

        private DayOfMonth(String value) {
            this(value, new BitSet(), false);
        }

        private DayOfMonth(String value, BitSet set, boolean last) {
            super(value);
            this.set = set;
            this.last = last;
        }

        private DayOfMonth(int day) {
            this("" + day, new BitSet(), false);
            this.set.set(day, true);
        }

        private DayOfMonth(List<Integer> days, boolean last) {
            this(DayOfMonth.format(days, last), new BitSet(), last);
            for (int day : days) {
                this.set.set(day, true);
            }
        }

        public boolean singleDay() {
            return this.set.cardinality() == 1;
        }

        public int day() {
            return this.set.nextSetBit(0);
        }

        public boolean isSelected(int day) {
            return this.set.get(day);
        }

        public boolean hasLast() {
            return this.last;
        }

        public static DayOfMonth days(List<Integer> days, boolean last) {
            return new DayOfMonth(days, last);
        }

        public static DayOfMonth day(int day) {
            return new DayOfMonth(day);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static DayOfMonth parse(String value) {
            boolean last = false;
            BitSet set = new BitSet();
            if (value.contains("-")) {
                String[] parts = value.split("-");
                if (parts.length != 2) throw new IllegalArgumentException("Invalid day of month: " + value);
                int start = Integer.parseInt(parts[0]);
                int end = Integer.parseInt(parts[1]);
                set.set(start, end + 1, true);
                return new DayOfMonth(value, set, last);
            } else if (value.contains(",")) {
                String[] parts;
                for (String part : parts = value.split(",")) {
                    if ("L".equals(part)) {
                        last = true;
                        continue;
                    }
                    set.set(Integer.parseInt(part), true);
                }
                return new DayOfMonth(value, set, last);
            } else if (StringUtils.isNumeric((CharSequence)value)) {
                set.set(Integer.parseInt(value), true);
                return new DayOfMonth(value, set, last);
            } else {
                if (!"L".equals(value)) return new DayOfMonth(value, set, last);
                last = true;
            }
            return new DayOfMonth(value, set, last);
        }

        private static String format(List<Integer> days, boolean last) {
            String result = StringUtils.join(days.iterator(), (char)',');
            if (last) {
                if (result.length() != 0) {
                    result = result + ",";
                }
                result = result + "L";
            }
            return result;
        }
    }
}

