/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.joda.time.Period;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;

public class AppointmentSeries
extends ScheduleEventSeries {
    private Period noReminderPeriod;

    public AppointmentSeries(Act appointment, IArchetypeService service) {
        super(appointment, service);
    }

    public void setNoReminderPeriod(Period noReminderPeriod) {
        this.noReminderPeriod = noReminderPeriod;
    }

    @Override
    protected ScheduleEventSeries.State copy(ScheduleEventSeries.State state) {
        return new AppointmentState((AppointmentState)state);
    }

    @Override
    protected ScheduleEventSeries.State createState(IMObjectBean bean) {
        return new AppointmentState(bean);
    }

    @Override
    protected boolean canCalculateSeries(ScheduleEventSeries.State state) {
        return super.canCalculateSeries(state) && ((AppointmentState)state).getAppointmentType() != null;
    }

    @Override
    protected IMObjectBean populate(Act act, Times times, ScheduleEventSeries.State state) {
        IMObjectBean bean = super.populate(act, times, state);
        AppointmentState appointment = (AppointmentState)state;
        if (this.noReminderPeriod != null) {
            boolean sendReminder = false;
            Date now = new Date();
            Date startTime = act.getActivityStartTime();
            if (startTime.after(now)) {
                if (appointment.getSendReminder()) {
                    if (act.isNew()) {
                        Date to = DateRules.plus((Date)now, (Period)this.noReminderPeriod);
                        if (startTime.after(to)) {
                            sendReminder = true;
                        }
                    } else {
                        sendReminder = true;
                    }
                }
                bean.setValue("sendReminder", (Object)sendReminder);
            }
        }
        return bean;
    }

    @Override
    protected void populate(IMObjectBean bean, ScheduleEventSeries.State state) {
        super.populate(bean, state);
        Act act = (Act)bean.getObject(Act.class);
        AppointmentState appointment = (AppointmentState)state;
        bean.setTarget("appointmentType", appointment.getAppointmentType());
        act.setStatus(appointment.getStatus());
        bean.setTarget("customer", appointment.getCustomer());
        bean.setTarget("patient", appointment.getPatient());
        bean.setTarget("clinician", appointment.getClinician());
        act.setReason(appointment.getReason());
        bean.setValue("notes", (Object)appointment.getNotes());
    }

    static class AppointmentState
    extends ScheduleEventSeries.State {
        private Reference appointmentType;
        private String status;
        private Reference customer;
        private Reference patient;
        private Reference clinician;
        private String reason;
        private String notes;
        private boolean sendReminder;

        public AppointmentState(IMObjectBean appointment) {
            super(appointment);
        }

        public AppointmentState(AppointmentState state) {
            super(state);
            this.appointmentType = state.appointmentType;
            this.status = state.status;
            this.customer = state.customer;
            this.patient = state.patient;
            this.clinician = state.clinician;
            this.reason = state.reason;
            this.notes = state.notes;
            this.sendReminder = state.sendReminder;
        }

        @Override
        public void update(IMObjectBean appointment) {
            super.update(appointment);
            Act act = (Act)appointment.getObject(Act.class);
            this.appointmentType = appointment.getTargetRef("appointmentType");
            this.status = act.getStatus();
            this.customer = appointment.getTargetRef("customer");
            this.patient = appointment.getTargetRef("patient");
            this.clinician = appointment.getTargetRef("clinician");
            this.reason = appointment.getString("reason");
            this.notes = appointment.getString("notes");
            this.sendReminder = appointment.getBoolean("sendReminder");
        }

        public Reference getAppointmentType() {
            return this.appointmentType;
        }

        public String getStatus() {
            return this.status;
        }

        public Reference getCustomer() {
            return this.customer;
        }

        public Reference getPatient() {
            return this.patient;
        }

        public Reference getClinician() {
            return this.clinician;
        }

        public String getReason() {
            return this.reason;
        }

        public String getNotes() {
            return this.notes;
        }

        public boolean getSendReminder() {
            return this.sendReminder;
        }

        @Override
        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof AppointmentState && super.equals(obj)) {
                AppointmentState other = (AppointmentState)obj;
                result = new EqualsBuilder().append((Object)this.appointmentType, (Object)other.appointmentType).append((Object)this.status, (Object)other.status).append((Object)this.customer, (Object)other.customer).append((Object)this.patient, (Object)other.patient).append((Object)this.clinician, (Object)other.clinician).append((Object)this.reason, (Object)other.reason).append((Object)this.notes, (Object)other.notes).append(this.sendReminder, other.sendReminder).isEquals();
            }
            return result;
        }
    }
}

