/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.boarding;

import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Table;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.AbstractMultiDayScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.AbstractMultiDayTableModel;
import org.openvpms.web.workspace.workflow.appointment.boarding.AbstractCageTableCellRenderer;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageSummaryTableModel;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageTableModel;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;

class CageSummaryTableCellRenderer
extends AbstractCageTableCellRenderer {
    private final String day = Messages.get((String)"workflow.scheduling.appointment.summary.day");
    private final String overnight = Messages.get((String)"workflow.scheduling.appointment.summary.overnight");
    private final String checkout = Messages.get((String)"workflow.scheduling.appointment.summary.checkout");

    public CageSummaryTableCellRenderer(CageSummaryTableModel model) {
        super(model);
    }

    @Override
    protected Component getEvent(Table table, PropertySet event, int column, int row) {
        Date startTime = event.getDate("act.startTime");
        Date endTime = event.getDate("act.endTime");
        int slot = column - 1;
        CageTableModel model = this.getModel();
        AbstractMultiDayScheduleGrid grid = ((AbstractMultiDayTableModel)model).getGrid();
        Label label = LabelFactory.create();
        if (!Schedule.isBlockingEvent(event)) {
            Date endDate;
            Date startDate = DateRules.getDate((Date)startTime);
            if (startDate.equals(endDate = DateRules.getDate((Date)endTime)) || DateRules.compareTo((Date)endTime, (Date)DateRules.getNextDate((Date)startDate)) == 0) {
                label.setText(this.day);
            } else {
                Date date = grid.getDate(slot);
                if (date.compareTo(endDate) < 0) {
                    label.setText(this.overnight);
                } else {
                    label.setText(this.checkout);
                }
            }
        }
        this.styleEvent(event, (Component)label, table);
        return label;
    }
}

