/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.boarding;

import java.util.Objects;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageScheduleGroup;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;

class CageRow {
    private final CageScheduleGroup group;
    private final Schedule schedule;

    public CageRow() {
        this(null, null);
    }

    public CageRow(CageScheduleGroup group, Schedule schedule) {
        this.group = group;
        this.schedule = schedule;
    }

    public boolean isTotal() {
        return this.group == null;
    }

    public boolean isSummary() {
        return this.schedule == null;
    }

    public String getName() {
        return this.schedule != null ? this.schedule.getName() : (this.group != null ? this.group.getName() : Messages.get((String)"workflow.scheduling.appointment.total"));
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public boolean isSchedule(Entity schedule) {
        return this.schedule != null && Objects.equals(this.schedule.getSchedule(), schedule);
    }

    public boolean isSchedule(Reference scheduleRef) {
        return this.schedule != null && this.schedule.getSchedule().getObjectReference().equals((Object)scheduleRef);
    }

    public CageScheduleGroup getGroup() {
        return this.group;
    }

    public boolean renderEven() {
        return this.schedule == null || this.schedule.getRenderEven();
    }
}

