/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import org.joda.time.DateTime;

public enum TimeRange {
    ALL(0, 24),
    MORNING(8, 12),
    AFTERNOON(12, 17),
    EVENING(17, 24),
    AM(0, 12),
    PM(12, 24);

    private final int startMins;
    private final int endMins;

    private TimeRange(int startHour, int endHour) {
        this.startMins = startHour * 60;
        this.endMins = endHour * 60;
    }

    public int getStartMins() {
        return this.startMins;
    }

    public int getEndMins() {
        return this.endMins;
    }

    public static TimeRange getRange(Date time) {
        DateTime dateTime = new DateTime((Object)time);
        int hour = dateTime.getHourOfDay();
        if (hour < 8) {
            return AM;
        }
        if (hour >= 8 && hour < 12) {
            return MORNING;
        }
        if (hour >= 12 && hour < 17) {
            return AFTERNOON;
        }
        if (hour >= 17) {
            return EVENING;
        }
        return ALL;
    }

    public static TimeRange getAMorPM(DateTime time) {
        return time.getHourOfDay() < 12 ? AM : PM;
    }

    public static TimeRange getMorningOrAfternoonOrEvening(DateTime time) {
        int hour = time.getHourOfDay();
        if (hour < 12) {
            return MORNING;
        }
        if (hour < 15) {
            return AFTERNOON;
        }
        return EVENING;
    }
}

