/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.workflow.CalendarBlock;
import org.openvpms.archetype.rules.workflow.CalendarBlocks;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.component.system.common.cache.MapIMObjectCache;

public class OverlappingEvents {
    private final Entity schedule;
    private final IArchetypeService service;
    private List<Times> events;

    public OverlappingEvents(Entity schedule, List<Times> events, IArchetypeService service) {
        this.schedule = schedule;
        this.events = events;
        this.service = service;
    }

    public List<Times> getEvents() {
        return this.events;
    }

    public Times getFirstOverlap() {
        return !this.events.isEmpty() ? this.events.get(0) : null;
    }

    public Times getFirstAppointment() {
        for (Times event : this.events) {
            if (!event.getReference().isA("act.customerAppointment")) continue;
            return event;
        }
        return null;
    }

    public List<Times> getAppointments() {
        ArrayList<Times> result = new ArrayList<Times>();
        for (Times event : this.events) {
            if (!event.getReference().isA("act.customerAppointment")) continue;
            result.add(event);
        }
        return result;
    }

    public CalendarBlocks getCalendarBlocks(Party customer) {
        CalendarBlock reserved = null;
        ArrayList<CalendarBlock> unreserved = new ArrayList<CalendarBlock>();
        MapIMObjectCache cache = new MapIMObjectCache((ArchetypeService)this.service);
        HashMap<Reference, Boolean> flags = new HashMap<Reference, Boolean>();
        for (Times event : new ArrayList<Times>(this.events)) {
            CalendarBlock block;
            Act act;
            if (!event.getReference().isA("act.calendarBlock") || (act = (Act)this.service.get(event.getReference(), Act.class)) == null || (block = this.getCalendarBlock(act, customer, (IMObjectCache)cache, flags)) == null) continue;
            if (block.isReserved()) {
                reserved = block;
                break;
            }
            unreserved.add(block);
        }
        return reserved == null && unreserved.isEmpty() ? null : new CalendarBlocks(reserved, unreserved);
    }

    public boolean allowDoubleBooking() {
        IMObjectBean bean = this.service.getBean((IMObject)this.schedule);
        return bean.getBoolean("allowDoubleBooking");
    }

    private CalendarBlock getCalendarBlock(Act act, Party customer, IMObjectCache cache, Map<Reference, Boolean> reservedBlocks) {
        Entity blockType;
        CalendarBlock result = null;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Reference type = bean.getTargetRef("type");
        boolean reserved = false;
        if (type != null && (blockType = (Entity)cache.get(type)) != null) {
            Boolean isReserved = reservedBlocks.get(type);
            if (isReserved == null) {
                IMObjectBean typeBean = this.service.getBean((IMObject)blockType);
                List accountTypes = typeBean.getValues("customerAccountTypes", Lookup.class);
                List customerTypes = typeBean.getValues("customerTypes", Lookup.class);
                if (!(accountTypes.isEmpty() && customerTypes.isEmpty() || this.hasClassification(customer, accountTypes, (List<Lookup>)customerTypes))) {
                    reserved = true;
                }
                reservedBlocks.put(type, reserved);
            }
            result = new CalendarBlock(act, blockType, reserved, this.service);
        }
        return result;
    }

    private boolean hasClassification(Party customer, List<Lookup> accountTypes, List<Lookup> customerTypes) {
        IMObjectBean customerBean = this.service.getBean((IMObject)customer);
        return this.hasClassification(customerBean, "type", accountTypes) || this.hasClassification(customerBean, "classifications", customerTypes);
    }

    private boolean hasClassification(IMObjectBean customer, String name, List<Lookup> classifications) {
        if (!classifications.isEmpty()) {
            for (Lookup lookup : customer.getValues(name, Lookup.class)) {
                if (!classifications.contains(lookup)) continue;
                return true;
            }
        }
        return false;
    }
}

