/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.workflow.CalendarBlock;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class OverlappingCalendarEventDialog
extends ModalDialog {
    private final String message;
    private final List<Object> overlaps = new ArrayList<Object>();

    public OverlappingCalendarEventDialog(String title, String message, Times event, String[] buttons) {
        super(title, "MediumWidthHeightDialog", buttons);
        this.message = message;
        this.overlaps.add(event);
    }

    public OverlappingCalendarEventDialog(String title, String message, List<Times> appointments, List<CalendarBlock> blocks) {
        super(title, "MediumWidthHeightDialog", OK_CANCEL);
        this.message = message;
        this.overlaps.addAll(appointments);
        this.overlaps.addAll(blocks);
    }

    protected void doLayout() {
        Label label = LabelFactory.create((boolean)true);
        label.setText(this.message);
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{label, this.getTable()});
        Column inset = ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column});
        this.getLayout().add((Component)inset);
    }

    private Component getTable() {
        ListResultSet set = new ListResultSet(this.overlaps, 20);
        OverlapModel model = new OverlapModel();
        PagedIMTable table = new PagedIMTable((IMTableModel)model, (ResultSet)set);
        return table.getComponent();
    }

    private static class OverlapModel
    extends AbstractIMTableModel<Object> {
        public static final int ARCHETYPE_INDEX = 0;
        private static final int START_INDEX = 1;
        private static final int END_INDEX = 2;
        private static final int DESCRIPTION_INDEX = 3;

        public OverlapModel() {
            TableColumn startTime = new TableColumn(1);
            TableColumn endTime = new TableColumn(2);
            ArchetypeService service = this.getService();
            startTime.setHeaderValue((Object)DescriptorHelper.getDisplayName((String)"act.customerAppointment", (String)"startTime", (ArchetypeService)service));
            endTime.setHeaderValue((Object)DescriptorHelper.getDisplayName((String)"act.customerAppointment", (String)"endTime", (ArchetypeService)service));
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(OverlapModel.createTableColumn((int)0, (String)"table.imobject.archetype"));
            model.addColumn(startTime);
            model.addColumn(endTime);
            model.addColumn(OverlapModel.createTableColumn((int)3, (String)"table.imobject.description"));
            this.setTableColumnModel((TableColumnModel)model);
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return null;
        }

        protected Object getValue(Object object, TableColumn column, int row) {
            int index = column.getModelIndex();
            String result = null;
            switch (index) {
                case 0: {
                    result = this.getArchetypeName(object);
                    break;
                }
                case 1: {
                    result = this.getStartTime(object);
                    break;
                }
                case 2: {
                    result = this.getEndTime(object);
                    break;
                }
                case 3: {
                    result = this.getDescription(object);
                }
            }
            return result;
        }

        private String getArchetypeName(Object object) {
            ArchetypeService service = this.getService();
            if (object instanceof Times) {
                return DescriptorHelper.getDisplayName((String)((Times)object).getReference().getArchetype(), (ArchetypeService)service);
            }
            return DescriptorHelper.getDisplayName((String)"act.calendarBlock", (ArchetypeService)service);
        }

        private String getStartTime(Object object) {
            Date startTime = object instanceof Times ? ((Times)object).getStartTime() : ((CalendarBlock)object).getStartTime();
            return DateFormatter.formatDateTimeAbbrev((Date)startTime);
        }

        private String getEndTime(Object object) {
            Date startTime = object instanceof Times ? ((Times)object).getEndTime() : ((CalendarBlock)object).getEndTime();
            return DateFormatter.formatDateTimeAbbrev((Date)startTime);
        }

        private String getDescription(Object object) {
            String result = null;
            if (object instanceof CalendarBlock) {
                result = ((CalendarBlock)object).getName();
            }
            return result;
        }
    }
}

