/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.CalendarBlockSeries;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;

public class CalendarBlockEditor
extends AbstractCalendarEventEditor {
    public CalendarBlockEditor(Act act, IMObject parent, LayoutContext context) {
        this(act, parent, false, context);
    }

    public CalendarBlockEditor(Act act, IMObject parent, boolean editSeries, LayoutContext context) {
        super(act, parent, editSeries, context);
        this.addStartEndTimeListeners();
    }

    public IMObjectEditor newInstance() {
        boolean editSeries = this.getSeriesEditor() != null;
        return new CalendarBlockEditor((Act)this.reload((IMObject)this.getObject()), this.getParent(), editSeries, this.getLayoutContext());
    }

    @Override
    protected ScheduleEventSeries createSeries() {
        return new CalendarBlockSeries(this.getObject(), (IArchetypeService)ServiceHelper.getArchetypeService());
    }

    @Override
    protected void calculateEndTime() {
        Date start = this.getStartTime();
        int slotSize = this.getSlotSize();
        if (start != null && slotSize != 0) {
            Date end = DateRules.getDate((Date)start, (int)slotSize, (DateUnits)DateUnits.MINUTES);
            this.setEndTime(end);
        }
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new AbstractCalendarEventEditor.LayoutStrategy();
    }
}

