/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow;

import java.util.ArrayList;
import java.util.Date;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.ClinicalEventFactory;
import org.openvpms.web.workspace.workflow.WorkflowException;
import org.openvpms.web.workspace.workflow.i18n.WorkflowMessages;

public class GetClinicalEventTask
extends SynchronousTask {
    private final Date date;
    private final String reason;
    private final Act appointment;
    private final boolean newEvent;

    public GetClinicalEventTask(Date date) {
        this(date, null);
    }

    public GetClinicalEventTask(Date date, Act appointment) {
        this(date, null, appointment, false);
    }

    public GetClinicalEventTask(Date date, String reason, Act appointment, boolean newEvent) {
        this.date = date;
        this.reason = reason;
        this.appointment = appointment;
        this.newEvent = newEvent;
    }

    public Act getAppointment() {
        return this.appointment;
    }

    public void execute(TaskContext context) {
        Party patient = context.getPatient();
        if (patient == null) {
            throw new WorkflowException(WorkflowMessages.contextHasNoPatient());
        }
        Party location = context.getLocation();
        if (location == null) {
            throw new WorkflowException(WorkflowMessages.contextHasNoLocation());
        }
        User clinician = context.getClinician();
        ClinicalEventFactory factory = new ClinicalEventFactory((IArchetypeService)ServiceHelper.getArchetypeService(), (MedicalRecordRules)ServiceHelper.getBean(MedicalRecordRules.class), (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class));
        try {
            Act event = factory.getEvent(this.date, patient, clinician, this.appointment, this.reason, context.getLocation(), this.newEvent);
            if (event.isNew()) {
                ArrayList<Act> toSave = new ArrayList<Act>();
                toSave.add(event);
                IArchetypeRuleService service = ServiceHelper.getArchetypeService();
                if (this.appointment != null) {
                    IMObjectBean appointmentBean = service.getBean((IMObject)this.appointment);
                    appointmentBean.addTarget("event", (IMObject)event, "appointment");
                    toSave.add(this.appointment);
                }
                service.save(toSave);
            }
            context.addObject((IMObject)event);
        }
        catch (IllegalStateException exception) {
            InformationDialog.show((String)exception.getMessage(), (WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    GetClinicalEventTask.this.notifyCancelled();
                }
            });
        }
    }
}

