/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.AbstractNodeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.workspace.supplier.SupplierActQuery;

public class OrderQuery
extends SupplierActQuery<FinancialAct> {
    private LookupField deliveryStatus;
    private static final ActStatuses STATUSES = new ActStatuses("act.supplierOrder");
    private static final String DELIVERY_STATUS = "status2";

    public OrderQuery(String[] shortNames, LayoutContext context) {
        super(shortNames, STATUSES, FinancialAct.class, context);
    }

    public ResultSet<FinancialAct> query(SortConstraint[] sort) {
        return this.createResultSet(sort);
    }

    public Extent getHeight() {
        return this.getHeight(2);
    }

    protected void doLayout(Component container) {
        Row row1 = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
        Row row2 = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
        this.addSupplierSelector((Component)row1);
        this.addStockLocationSelector((Component)row1);
        this.addStatusSelector((Component)row1);
        this.addDeliveryStatus((Component)row1);
        this.addDateRange((Component)row2);
        container.add((Component)ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{row1, row2}));
    }

    @Override
    protected ResultSet<FinancialAct> createResultSet(ParticipantConstraint[] participants, SortConstraint[] sort) {
        AbstractNodeConstraint constraints = null;
        String deliveryStatus = this.getDeliveryStatus();
        if (deliveryStatus != null) {
            constraints = Constraints.eq((String)DELIVERY_STATUS, (Object)deliveryStatus);
        }
        return new ActResultSet(this.getArchetypeConstraint(), participants, this.getFrom(), this.getTo(), this.getStatuses(), this.excludeStatuses(), (IConstraint)constraints, this.getMaxResults(), sort);
    }

    private String getDeliveryStatus() {
        return this.deliveryStatus.getSelectedCode();
    }

    private void addDeliveryStatus(Component container) {
        Label label = LabelFactory.create();
        String displayName = DescriptorHelper.getDisplayName((String)"act.supplierOrder", (String)DELIVERY_STATUS, (ArchetypeService)this.getService());
        label.setText(displayName);
        NodeLookupQuery source = new NodeLookupQuery("act.supplierOrder", DELIVERY_STATUS);
        this.deliveryStatus = LookupFieldFactory.create((LookupQuery)source, (boolean)true);
        this.getFocusGroup().add((Component)this.deliveryStatus);
        container.add((Component)label);
        container.add((Component)this.deliveryStatus);
    }
}

