/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.text.TextComponent;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.supplier.DeliveryStatus;
import org.openvpms.archetype.rules.supplier.OrderRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditableIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.act.FinancialActEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.LookupFilter;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.act.ActLayoutStrategy;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.supplier.SupplierHelper;
import org.openvpms.web.workspace.supplier.order.OrderItemEditor;

public class OrderEditor
extends FinancialActEditor {
    private final boolean limitEditing;
    private final boolean posted;
    private final boolean accepted;
    private final OrderRules rules;
    private TextComponent deliveryStatusField;
    private static final String STATUS = "status";
    private static final String DELIVERY_STATUS = "status2";

    public OrderEditor(FinancialAct act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
        if (!act.isA("act.supplierOrder")) {
            throw new IllegalArgumentException("Invalid act type: " + act.getArchetype());
        }
        String status = act.getStatus();
        this.posted = "POSTED".equals(status);
        this.accepted = "ACCEPTED".equals(status);
        this.limitEditing = this.posted || this.accepted || "CANCELLED".equals(status);
        this.rules = SupplierHelper.createOrderRules(context.getContext().getPractice());
        this.initialise();
    }

    public IMObjectEditor newInstance() {
        return new OrderEditor((FinancialAct)this.reload((IMObject)this.getObject()), this.getParent(), this.getLayoutContext());
    }

    public String getDeliveryStatus() {
        return this.getProperty(DELIVERY_STATUS).getString();
    }

    protected ActRelationshipCollectionEditor getItems() {
        return super.getItems();
    }

    protected boolean doValidation(Validator validator) {
        return this.checkRestricted(validator) && super.doValidation(validator);
    }

    protected boolean checkRestricted(Validator validator) {
        boolean valid = true;
        if (!this.posted && "POSTED".equals(this.getStatus())) {
            Context context = this.getLayoutContext().getContext();
            Party practice = context.getPractice();
            User user = context.getUser();
            if (practice != null) {
                PracticeRules practiceRules = (PracticeRules)ServiceHelper.getBean(PracticeRules.class);
                UserRules userRules = (UserRules)ServiceHelper.getBean(UserRules.class);
                if (!userRules.isClinician(user) && practiceRules.isOrderingRestricted(practice)) {
                    for (IMObjectEditor editor : this.getItems().getEditors()) {
                        OrderItemEditor itemEditor = (OrderItemEditor)editor;
                        if (!itemEditor.isRestrictedProduct()) continue;
                        validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"supplier.order.restricted.message")));
                        valid = false;
                        break;
                    }
                }
            }
        }
        return valid;
    }

    protected void onItemsChanged() {
        super.onItemsChanged();
        List acts = this.getItems().getCurrentActs();
        this.checkDeliveryStatus(acts);
    }

    protected ActRelationshipCollectionEditor createItemsEditor(Act act, CollectionProperty items) {
        ActRelationshipCollectionEditor result = super.createItemsEditor(act, items);
        result.setCardinalityReadOnly(this.limitEditing);
        return result;
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LayoutStrategy((EditableIMObjectCollectionEditor)this.getItems());
    }

    private void checkDeliveryStatus(List<Act> acts) {
        DeliveryStatus current;
        Property deliveryStatus = this.getProperty(DELIVERY_STATUS);
        int full = 0;
        int part = 0;
        int pending = 0;
        block4: for (Act act : acts) {
            FinancialAct item = (FinancialAct)act;
            DeliveryStatus status = this.rules.getDeliveryStatus(item);
            switch (status) {
                case FULL: {
                    ++full;
                    continue block4;
                }
                case PART: {
                    ++part;
                    continue block4;
                }
            }
            ++pending;
        }
        DeliveryStatus newStatus = full != 0 ? (part == 0 && pending == 0 ? DeliveryStatus.FULL : DeliveryStatus.PART) : (part != 0 ? DeliveryStatus.PART : DeliveryStatus.PENDING);
        if (newStatus != (current = DeliveryStatus.valueOf((String)((String)deliveryStatus.getValue())))) {
            deliveryStatus.setValue((Object)newStatus.toString());
            this.deliveryStatusField.setText(LookupNameHelper.getName((IMObject)this.getObject(), (String)deliveryStatus.getName()));
        }
    }

    private class LayoutStrategy
    extends ActLayoutStrategy {
        LayoutStrategy(EditableIMObjectCollectionEditor editor) {
            super((IMObjectCollectionEditor)editor);
        }

        protected ComponentState createComponent(Property property, IMObject parent, LayoutContext context) {
            ComponentState state;
            if (property.getName().equals(OrderEditor.DELIVERY_STATUS)) {
                property = this.createReadOnly(property);
                state = super.createComponent(property, parent, context);
                OrderEditor.this.deliveryStatusField = (TextComponent)state.getComponent();
            } else if (OrderEditor.this.limitEditing) {
                if (property.getName().equals(OrderEditor.STATUS) && (OrderEditor.this.posted || OrderEditor.this.accepted)) {
                    NodeLookupQuery query = new NodeLookupQuery(parent, property);
                    query = OrderEditor.this.posted ? new LookupFilter((LookupQuery)query, true, new String[]{"POSTED", "CANCELLED"}) : new LookupFilter((LookupQuery)query, true, new String[]{"ACCEPTED", "CANCELLED"});
                    LookupField field = LookupFieldFactory.create((Property)property, (LookupQuery)query);
                    state = new ComponentState((Component)field, property);
                } else {
                    property = this.createReadOnly(property);
                    state = super.createComponent(property, parent, context);
                }
            } else {
                state = super.createComponent(property, parent, context);
            }
            return state;
        }
    }
}

