/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.component.processor.BatchProcessorListener;
import org.openvpms.archetype.rules.supplier.OrderRules;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.esci.adapter.client.OrderServiceAdapter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.processor.BatchProcessorDialog;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.ActPoster;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.supplier.SelectStockDetailsDialog;
import org.openvpms.web.workspace.supplier.SupplierHelper;
import org.openvpms.web.workspace.supplier.order.ESCISupplierCRUDWindow;
import org.openvpms.web.workspace.supplier.order.OrderActions;
import org.openvpms.web.workspace.supplier.order.OrderProgressBarProcessor;
import org.openvpms.web.workspace.supplier.order.StockLocationSupplierDialog;
import org.openvpms.web.workspace.supplier.order.SupplierOrderPoster;

public class OrderCRUDWindow
extends ESCISupplierCRUDWindow {
    private static final String COPY_ID = "copy";
    private static final String GENERATE_ID = "button.generateOrders";

    public OrderCRUDWindow(Archetypes<FinancialAct> archetypes, Context context, HelpContext help) {
        super(archetypes, OrderActions.INSTANCE, context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createPostButton());
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
        buttons.add(COPY_ID, this::onCopy);
        buttons.add(GENERATE_ID, this::onGenerate);
        buttons.add(this.createCheckInboxButton());
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        boolean editEnabled = false;
        boolean deletePostEnabled = false;
        if (enable) {
            FinancialAct object = (FinancialAct)this.getObject();
            editEnabled = this.getActions().canEdit((Act)object);
            String status = object.getStatus();
            deletePostEnabled = !"POSTED".equals(status) && !"ACCEPTED".equals(status) && !"CANCELLED".equals(status);
        }
        buttons.setEnabled("button.edit", editEnabled);
        buttons.setEnabled("button.delete", deletePostEnabled);
        buttons.setEnabled("button.post", deletePostEnabled);
        this.enablePrintPreview(buttons, enable);
        buttons.setEnabled(COPY_ID, enable);
    }

    @Override
    protected void onCreated(final FinancialAct act) {
        String title = Messages.format((String)"supplier.order.selectdetails.title", (Object[])new Object[]{this.getDisplayName((IMObject)act)});
        final SelectStockDetailsDialog dialog = new SelectStockDetailsDialog(title, this.getContext(), this.getHelpContext().subtopic("new"));
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                Party supplier = dialog.getSupplier();
                Party location = dialog.getStockLocation();
                OrderCRUDWindow.this.addParticipations((Act)act, supplier, location);
                OrderCRUDWindow.this.edit((IMObject)act, null);
            }
        });
        dialog.show();
    }

    protected void onCopy() {
        try {
            OrderRules rules = SupplierHelper.createOrderRules(this.getContext().getPractice());
            FinancialAct object = (FinancialAct)this.getObject();
            String title = null;
            if (!StringUtils.isEmpty((CharSequence)object.getTitle())) {
                title = Messages.format((String)"supplier.order.copy.notes", (Object[])new Object[]{object.getTitle()});
            }
            FinancialAct copy = rules.copyOrder(object, title);
            this.edit((IMObject)copy, null);
        }
        catch (OpenVPMSException exception) {
            String title = Messages.get((String)"supplier.order.copy.failed");
            ErrorHelper.show((String)title, (Throwable)exception);
        }
    }

    protected ActPoster<FinancialAct> getActPoster(FinancialAct object) {
        HelpContext help = this.getHelpContext().subtopic("post");
        return new SupplierOrderPoster(object, OrderActions.INSTANCE, this.getContext(), help);
    }

    protected void onPosted(FinancialAct act) {
        SupplierRules rules = new SupplierRules((IArchetypeService)ServiceHelper.getArchetypeService());
        if (rules.getSupplierStockLocation((Act)act) != null) {
            if (this.submitOrder(act)) {
                InformationDialog.show((String)Messages.get((String)"supplier.order.sent.title"), (String)Messages.get((String)"supplier.order.sent.message"));
                this.scheduleCheckInbox(true);
            }
        } else {
            this.print((Act)act);
        }
    }

    protected boolean submitOrder(FinancialAct act) {
        boolean submitted = false;
        try {
            OrderServiceAdapter service = ServiceHelper.getOrderService();
            service.submitOrder(act);
            submitted = true;
        }
        catch (Throwable exception) {
            act.setStatus("IN_PROGRESS");
            SaveHelper.save((IMObject)act);
            ErrorHelper.show((Throwable)exception);
            this.onRefresh((IMObject)act);
        }
        return submitted;
    }

    private void onGenerate() {
        String title = Messages.get((String)"supplier.order.generate.title");
        final HelpContext help = this.getHelpContext().subtopic("generate");
        final StockLocationSupplierDialog dialog = new StockLocationSupplierDialog(title, this.getContext(), help);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                Party location = dialog.getStockLocation();
                Party supplier = dialog.getSupplier();
                OrderCRUDWindow.this.generateOrders(location, supplier, dialog.getStockLocations(), dialog.getSuppliers(), dialog.getBelowIdealQuantity(), help);
            }
        });
        dialog.show();
    }

    private void generateOrders(Party stockLocation, Party supplier, List<IMObject> locations, List<IMObject> suppliers, boolean belowIdealQuantity, HelpContext help) {
        final String title = Messages.get((String)"supplier.order.generate.title");
        if (stockLocation != null) {
            locations = Collections.singletonList(stockLocation);
        }
        if (supplier != null) {
            suppliers = Collections.singletonList(supplier);
        }
        final OrderProgressBarProcessor processor = new OrderProgressBarProcessor(this.getContext().getPractice(), locations, suppliers, belowIdealQuantity, title);
        final BatchProcessorDialog dialog = new BatchProcessorDialog(processor.getTitle(), (ProgressBarProcessor)processor, help);
        processor.setListener(new BatchProcessorListener(){

            public void completed() {
                dialog.close();
                String message = Messages.format((String)"supplier.order.generated.message", (Object[])new Object[]{processor.getOrders()});
                InformationDialog.show((String)title, (String)message);
                OrderCRUDWindow.this.onRefresh((IMObject)((FinancialAct)null));
            }

            public void error(Throwable exception) {
                ErrorHelper.show((Throwable)exception);
                OrderCRUDWindow.this.onRefresh((IMObject)((FinancialAct)null));
            }
        });
        dialog.show();
    }
}

