/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.esci.adapter.dispatcher.ErrorHandler;
import org.openvpms.web.component.error.ErrorFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESCIErrorHandler
implements ErrorHandler {
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private static final Logger log = LoggerFactory.getLogger(ESCIErrorHandler.class);

    public boolean terminateOnError() {
        return false;
    }

    public void error(Throwable exception) {
        this.errors.add(exception);
        log.error(exception.getMessage(), exception);
    }

    public int getErrors() {
        return this.errors.size();
    }

    public String formatErrors() {
        StringBuilder builder = new StringBuilder();
        for (Throwable error : this.errors) {
            if (builder.length() != 0) {
                builder.append("\n");
            }
            builder.append(ErrorFormatter.format((Throwable)error));
        }
        return builder.toString();
    }
}

