/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.delivery;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.workspace.supplier.SupplierStockItemEditor;
import org.openvpms.web.workspace.supplier.delivery.DeliveryItemLayoutStrategy;

public class DeliveryItemEditor
extends SupplierStockItemEditor {
    private final ActRelationshipCollectionEditor orderEditor;
    private String parentStatus;
    private final boolean updateProductPrices;

    public DeliveryItemEditor(FinancialAct act, Act parent, LayoutContext context) {
        super(act, parent, context);
        CollectionProperty order = (CollectionProperty)this.getProperty("order");
        this.orderEditor = new ActRelationshipCollectionEditor(order, (Act)act, this.getLayoutContext());
        this.addEditor((Editor)this.orderEditor);
        this.parentStatus = parent != null ? parent.getStatus() : null;
        Property invoiceLineId = this.getProperty("supplierInvoiceLineId");
        this.updateProductPrices = invoiceLineId == null || StringUtils.isEmpty((CharSequence)invoiceLineId.getString());
    }

    public void setOrderItem(FinancialAct order) {
        this.orderEditor.add((IMObject)order);
    }

    public boolean validate(Validator validator) {
        String currentStatus = ((Act)this.getParent()).getStatus();
        if (!Objects.equals(this.parentStatus, currentStatus)) {
            this.parentStatus = currentStatus;
            this.resetValid(false);
        }
        return super.validate(validator);
    }

    protected boolean doValidation(Validator validator) {
        Act parent;
        boolean result = super.doValidation(validator);
        if (result && (parent = (Act)this.getParent()) != null && "POSTED".equals(parent.getStatus()) && (result = this.validateProduct(validator)) && (result = this.validatePackageSize(validator))) {
            result = this.validatePackageUnits(validator);
        }
        return result;
    }

    @Override
    protected void productModified(Product product) {
        if (this.updateProductPrices) {
            super.productModified(product);
        }
    }

    private boolean validateProduct(Validator validator) {
        boolean result = true;
        Property property = this.getProperty("product");
        if (this.getProductRef() == null) {
            result = this.reportRequired(property, validator);
        }
        return result;
    }

    private boolean validatePackageSize(Validator validator) {
        boolean result = true;
        Property property = this.getProperty("packageSize");
        Number size = (Number)property.getValue();
        if (size.intValue() <= 0) {
            result = this.reportRequired(property, validator);
        }
        return result;
    }

    private boolean validatePackageUnits(Validator validator) {
        boolean result = true;
        Property property = this.getProperty("packageUnits");
        String units = (String)property.getValue();
        if (units == null) {
            result = this.reportRequired(property, validator);
        }
        return result;
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new DeliveryItemLayoutStrategy();
    }

    @Override
    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        ProductParticipationEditor editor = this.getProductEditor();
        if (editor != null) {
            editor.setAllowCreate(true);
        }
    }
}

